/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.helpers;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component
public class SquashRequirementVersionLinkTypeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashRequirementVersionLinkTypeHelper.class);
    private static final String NATIVE_LINK_TYPE_RELATED = "requirement-version.link.type.related";
    private static final String NATIVE_LINK_TYPE_PARENT = "requirement-version.link.type.parent";
    private static final String NATIVE_LINK_TYPE_CHILD = "requirement-version.link.type.child";
    private static final String NATIVE_LINK_TYPE_DUPLICATE = "requirement-version.link.type.duplicate";
    private static final String REGULAR_LINK_TYPE_VALUE_FORMAT = "%1s - %2s (%3s - %4s)";
    private static final Set<String> NATIVE_LINK_SET = ImmutableSet.builder().add((Object[])new String[]{"requirement-version.link.type.child", "requirement-version.link.type.duplicate", "requirement-version.link.type.parent", "requirement-version.link.type.related"}).build();
    @Inject
    private LinkedRequirementVersionManagerService linkedRequirementVersionManagerService;
    @Inject
    private InternationalizationHelper i18nhelper;

    public Map<Long, String> createLinkTypeMap() {
        List requirementVersionLinkTypes = this.linkedRequirementVersionManagerService.getAllReqVersionLinkTypes();
        HashMap<Long, String> types = new HashMap<Long, String>();
        for (RequirementVersionLinkType req : requirementVersionLinkTypes) {
            String role1 = this.tryRoleInternationalization(req.getRole1());
            String role2 = this.tryRoleInternationalization(req.getRole2());
            String typeValue = String.format(REGULAR_LINK_TYPE_VALUE_FORMAT, role1, role2, req.getRole1Code(), req.getRole2Code());
            types.put(req.getId(), typeValue);
        }
        return types;
    }

    private String tryRoleInternationalization(String role) {
        if (NATIVE_LINK_SET.contains(role)) {
            role = this.i18nhelper.internationalize(role, LocaleContextHolder.getLocale());
        }
        return role;
    }
}

