/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ReportingFieldDto;
import org.squashtest.tm.plugin.rest.admin.service.RestReportingFieldService;

@Service
@Transactional
public class RestReportingFieldServiceImpl
implements RestReportingFieldService {
    public static final String TESTING_STATUS = "testingStatus";
    public static final String REDACTION_PROGRESS = "redactionProgress";
    public static final String VERIFICATION_PROGRESS = "verificationProgress";
    public static final String VALIDATION_PROGRESS = "validationProgress";
    public static final String REDACTION_RATIO = "redactionRatio";
    public static final String VERIFICATION_RATIO = "verificationRatio";
    public static final String VALIDATION_RATIO = "validationRatio";
    @Inject
    private PluginRequirementDao dao;

    @Override
    public ReportingFieldDto getReportingFieldBySquashFieldForProject(Long projectId, String squashField) {
        Configuration configuration = this.dao.getConfigurationForProject(projectId);
        switch (squashField) {
            case "testingStatus": {
                return new ReportingFieldDto(TESTING_STATUS, configuration.getStatusField());
            }
            case "redactionProgress": {
                return new ReportingFieldDto(REDACTION_PROGRESS, configuration.getRedactionProgressField());
            }
            case "verificationProgress": {
                return new ReportingFieldDto(VERIFICATION_PROGRESS, configuration.getVerificationProgressField());
            }
            case "validationProgress": {
                return new ReportingFieldDto(VALIDATION_PROGRESS, configuration.getValidationProgressField());
            }
            case "redactionRatio": {
                return new ReportingFieldDto(REDACTION_RATIO, configuration.getRedactionRatioField());
            }
            case "verificationRatio": {
                return new ReportingFieldDto(VERIFICATION_RATIO, configuration.getVerificationRatioField());
            }
            case "validationRatio": {
                return new ReportingFieldDto(VALIDATION_RATIO, configuration.getValidationRatioField());
            }
        }
        throw new IllegalArgumentException("No reporting field known with squash field '" + squashField + "'");
    }

    @Override
    public List<ReportingFieldDto> getAllReportingFieldsByProject(Long projectId) {
        Configuration configuration = this.dao.getConfigurationForProject(projectId);
        return this.buildReportingFields(configuration);
    }

    private List<ReportingFieldDto> buildReportingFields(Configuration configuration) {
        ArrayList<ReportingFieldDto> reportingFields = new ArrayList<ReportingFieldDto>();
        reportingFields.add(new ReportingFieldDto(TESTING_STATUS, configuration.getStatusField()));
        reportingFields.add(new ReportingFieldDto(REDACTION_PROGRESS, configuration.getRedactionProgressField()));
        reportingFields.add(new ReportingFieldDto(VERIFICATION_PROGRESS, configuration.getVerificationProgressField()));
        reportingFields.add(new ReportingFieldDto(VALIDATION_PROGRESS, configuration.getValidationProgressField()));
        reportingFields.add(new ReportingFieldDto(REDACTION_RATIO, configuration.getRedactionRatioField()));
        reportingFields.add(new ReportingFieldDto(VERIFICATION_RATIO, configuration.getVerificationRatioField()));
        reportingFields.add(new ReportingFieldDto(VALIDATION_RATIO, configuration.getValidationRatioField()));
        return reportingFields;
    }

    @Override
    public ReportingFieldDto updateReportingField(Long projectId, String squashField, ReportingFieldDto patchReportingFieldDto) {
        Configuration configuration = this.dao.getConfigurationForProject(projectId);
        String newJiraField = patchReportingFieldDto.getJiraField();
        switch (squashField) {
            case "testingStatus": {
                configuration.setStatusField(newJiraField);
                break;
            }
            case "redactionProgress": {
                configuration.setRedactionProgressField(newJiraField);
                break;
            }
            case "verificationProgress": {
                configuration.setVerificationProgressField(newJiraField);
                break;
            }
            case "validationProgress": {
                configuration.setValidationProgressField(newJiraField);
                break;
            }
            case "redactionRatio": {
                configuration.setRedactionRatioField(newJiraField);
                break;
            }
            case "verificationRatio": {
                configuration.setVerificationRatioField(newJiraField);
                break;
            }
            case "validationRatio": {
                configuration.setValidationRatioField(newJiraField);
                break;
            }
            default: {
                throw new IllegalArgumentException("No reporting field known with squash name '" + squashField + "'");
            }
        }
        this.dao.storeConfigurationForProject(projectId, configuration);
        return new ReportingFieldDto(squashField, newJiraField);
    }
}

