/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.JqlSearch;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSearchResult;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationDao;

@Service(value="squash.tm.plugin.jirasync.explanJslService")
@Transactional(readOnly=true)
class ExecplanJqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanJqlService.class);
    @Inject
    private ClientProvider clientProvider;
    @Inject
    private ExecplanSynchronizationDao dao;

    ExecplanJqlService() {
    }

    List<BugTracker> findQueriableServers() {
        return this.dao.findAllJiraServers();
    }

    List<ExecplanIssue> findTicketsByJql(JqlSearch jsearch) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("fetching JIRA tickets with a jql expression : {}", (Object)jsearch.logParameters());
        }
        BugTracker server = this.dao.findServerById(jsearch.getServerId());
        LOGGER.trace("server is : {}", (Object)server.getName());
        ArrayList<ExecplanIssue> issues = new ArrayList<ExecplanIssue>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (JiraClient client = this.clientProvider.createAuthenticatedClient(server);){
            if (client.isJiraCloudServer()) {
                this.fetchIssuesFromCloud(client, jsearch.getExpression(), issues);
            } else {
                this.fetchIssuesFromDataCenter(client, jsearch.getExpression(), issues);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return issues;
    }

    private void fetchIssuesFromCloud(JiraClient client, String jql, List<ExecplanIssue> issues) {
        JiraSearchResult<ExecplanIssue> result;
        String nextPageToken = null;
        int fetchCnt = 0;
        do {
            LOGGER.trace("paged REST call (Cloud), nextPageToken={}", nextPageToken);
            result = client.findExecplanIssueForJqlCloud(jql, nextPageToken).claim();
            for (ExecplanIssue jirssue : result.getIssues()) {
                ++fetchCnt;
                issues.add(jirssue);
            }
            LOGGER.trace("retrieved issues (Cloud): {} / {}", (Object)fetchCnt, (Object)result.getTotal());
        } while ((nextPageToken = result.getNextPageToken()) != null);
    }

    private void fetchIssuesFromDataCenter(JiraClient client, String jql, List<ExecplanIssue> issues) {
        JiraSearchResult<ExecplanIssue> result;
        int page = 0;
        int fetchCnt = 0;
        do {
            LOGGER.trace("paged REST call (DC), page={}", (Object)page);
            result = client.findExecplanIssueForJql(jql, page).claim();
            for (ExecplanIssue jirssue : result.getIssues()) {
                ++fetchCnt;
                issues.add(jirssue);
            }
            LOGGER.trace("retrieved issues (DC): {} / {}", (Object)fetchCnt, (Object)result.getTotal());
            ++page;
        } while (fetchCnt < result.getTotal());
    }
}

