/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.dummy;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.AuthenticationFieldsTranslationKeys;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.csp.core.bugtracker.domain.BTProject;
import org.squashtest.csp.core.bugtracker.domain.Category;
import org.squashtest.csp.core.bugtracker.domain.User;
import org.squashtest.csp.core.bugtracker.domain.Version;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.service.spi.BugTrackerConnector;

@Component
@Scope(value="prototype")
public class DummyJirasyncBugtrackerConnector
implements BugTrackerConnector {
    @Inject
    private Provider<JiraClient> provider;
    private BugTracker bugTracker;

    public void setBugTracker(BugTracker bugTracker) {
        this.bugTracker = bugTracker;
    }

    public AuthenticationProtocol[] getSupportedAuthProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH, AuthenticationProtocol.OAUTH_2};
    }

    public boolean supports(AuthenticationProtocol mode) {
        return JiraClient.PROTOCOLS.contains(mode);
    }

    public void authenticate(Credentials credentials) throws UnsupportedAuthenticationModeException {
    }

    public void checkCredentials(Credentials credentials) throws BugTrackerNoCredentialsException, BugTrackerRemoteException {
        AuthenticationProtocol protocol = credentials.getImplementedProtocol();
        if (!JiraClient.PROTOCOLS.contains(protocol)) {
            throw new IllegalArgumentException("unsupported credentials type : " + credentials.getClass().getSimpleName() + ". Only BasicAuthenticationCredentials or OAuth2Credentials are supported.");
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (JiraClient client = (JiraClient)this.provider.get();){
            client.initialize(this.bugTracker, credentials);
            client.checkCredentials();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getKeyForPassword(BugTracker bugTracker) {
        String atlassianUrl = ".atlassian.net";
        if (bugTracker.getUrl().contains(atlassianUrl)) {
            return AuthenticationFieldsTranslationKeys.TOKEN.key;
        }
        return AuthenticationFieldsTranslationKeys.PASSWORD.key;
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        throw new NonProductionUseException();
    }

    public String makeViewIssueUrlSuffix(String s) {
        throw new NonProductionUseException();
    }

    public BTProject findProject(String s) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public BTProject findProjectById(String s) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public List<Version> findVersions(String s) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public List<Version> findVersionsById(String s) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public List<Version> findVersions(BTProject btProject) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public List<User> findUsers(String s) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public List<User> findUsersById(String s) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public List<User> findUsers(BTProject btProject) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public BTIssue createIssue(BTIssue btIssue) throws BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public List<Category> findCategories(BTProject btProject) throws ProjectNotFoundException, BugTrackerRemoteException {
        throw new NonProductionUseException();
    }

    public BTIssue findIssue(String s) {
        throw new NonProductionUseException();
    }

    public List<BTIssue> findIssues(List<String> list) {
        throw new NonProductionUseException();
    }

    public static final class NonProductionUseException
    extends BugTrackerLocalException {
        public NonProductionUseException() {
            super("This is a dummy JIRA connector. It's a placeholder that allow to register your JIRA instance in the Bugtracker administration panel even when the plugin 'jira.rest' is not deployed. It allows the synchronization plug to work properly but won't provide for any issue managemement functionalities. The JIRA instances registered using this plugin should not be bound to a Squash project as its bugtracker.", null);
        }
    }
}

