/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.event.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import jirasync.com.atlassian.event.spi.ListenerInvoker;

final class SingleParameterMethodListenerInvoker
implements ListenerInvoker {
    private final Method method;
    private final Object listener;

    public SingleParameterMethodListenerInvoker(Object listener, Method method) {
        this.listener = Preconditions.checkNotNull((Object)listener);
        this.method = (Method)Preconditions.checkNotNull((Object)method);
    }

    @Override
    public Set<Class<?>> getSupportedEventTypes() {
        return Sets.newHashSet((Object[])this.method.getParameterTypes());
    }

    @Override
    public void invoke(Object event) {
        try {
            this.method.invoke(this.listener, event);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() == null) {
                throw new RuntimeException(e);
            }
            if (e.getCause().getMessage() == null) {
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e.getCause().getMessage(), e.getCause());
        }
    }

    @Override
    public boolean supportAsynchronousEvents() {
        return true;
    }

    public String toString() {
        return "SingleParameterMethodListenerInvoker{method=" + this.method + ", listener=" + this.paranoidToString(this.listener) + '}';
    }

    private String paranoidToString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (RuntimeException e) {
            return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
        }
    }
}

