/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.event.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import jirasync.com.atlassian.event.api.EventListener;
import jirasync.com.atlassian.event.internal.SingleParameterMethodListenerInvoker;
import jirasync.com.atlassian.event.spi.ListenerHandler;
import jirasync.com.atlassian.event.spi.ListenerInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedMethodsListenerHandler
implements ListenerHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class annotationClass;

    public AnnotatedMethodsListenerHandler() {
        this(EventListener.class);
    }

    public AnnotatedMethodsListenerHandler(Class annotationClass) {
        this.annotationClass = (Class)Preconditions.checkNotNull((Object)annotationClass);
    }

    @Override
    public List<? extends ListenerInvoker> getInvokers(final Object listener) {
        List<Method> validMethods = this.getValidMethods(Preconditions.checkNotNull((Object)listener));
        if (validMethods.isEmpty()) {
            this.log.debug("Couldn't find any valid listener methods on class <{}>", (Object)listener.getClass().getName());
        }
        return Lists.transform(validMethods, (Function)new Function<Method, ListenerInvoker>(){

            public ListenerInvoker apply(Method method) {
                return new SingleParameterMethodListenerInvoker(listener, method);
            }
        });
    }

    private List<Method> getValidMethods(Object listener) {
        ArrayList annotatedMethods = Lists.newArrayList();
        for (Method method : listener.getClass().getMethods()) {
            if (!this.isValidMethod(method)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    private boolean isValidMethod(Method method) {
        if (this.isAnnotated(method)) {
            if (this.hasOneAndOnlyOneParameter(method)) {
                return true;
            }
            throw new RuntimeException("Method <" + method + "> of class <" + method.getDeclaringClass() + "> " + "is annotated with <" + this.annotationClass.getName() + "> but has 0 or more than 1 parameters! " + "Listener methods MUST have 1 and only 1 parameter.");
        }
        return false;
    }

    private boolean isAnnotated(Method method) {
        return method.getAnnotation(this.annotationClass) != null;
    }

    private boolean hasOneAndOnlyOneParameter(Method method) {
        return method.getParameterTypes().length == 1;
    }
}

