/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.controller.model;

import jakarta.inject.Inject;
import java.util.Date;
import java.util.Locale;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModel;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component
@Scope(value="prototype")
public class JiraRemoteSynchronisationModelBuilder {
    private static final String SELECT_TYPE_ROOT_KEY = "henix.jirasync.configuration.sync.type.";
    @Inject
    private InternationalizationHelper inHelper;

    public JiraRemoteSynchronisationModel build(JiraRemoteSynchronisation sync) {
        Locale locale = LocaleContextHolder.getLocale();
        JiraRemoteSynchronisationModel model = new JiraRemoteSynchronisationModel();
        model.setId(sync.getId());
        model.setSynchronisationEnable(sync.isSynchronisationEnable());
        model.setSprintSynchronisationEnable(sync.isSprintSynchronisationEnable());
        model.setName(sync.getName());
        model.setServerName(sync.getServer().getName());
        model.setSynchronisationPath(sync.getSynchronisationPath());
        model.setServerId(sync.getServer().getId());
        model.setSelectTypeConst(sync.getSelectType());
        if (sync.hasOwner()) {
            model.setOwnerId(sync.getOwner().getId());
            model.setOwnerLogin(sync.getOwner().getLogin());
        }
        String typeKey = SELECT_TYPE_ROOT_KEY + sync.getSelectType().toLowerCase();
        model.setSelectType(this.inHelper.internationalize(typeKey, locale));
        Date lastSyncDate = sync.getLastSyncDate();
        Date lastSuccessfulSyncDate = sync.getLastSuccessfulSyncDate();
        model.setLastSyncDate(this.inHelper.localizeDateWithDefaultToNever(lastSyncDate, locale));
        model.setLastSuccessfulSyncDate(this.inHelper.localizeDateWithDefaultToNever(lastSuccessfulSyncDate, locale));
        model.setLastSyncOn(lastSyncDate);
        model.setLastSuccessfulSyncOn(lastSuccessfulSyncDate);
        model.setSelectValue(sync.getSelectValue());
        model.setAdditionalJQL(sync.getAdditionalJQL());
        boolean isBoard = sync.isBoard();
        boolean isRestrictedToActiveSprint = sync.isRestrictedToActiveSprint();
        model.setRestrictedToActiveSprint(isRestrictedToActiveSprint);
        String isRestrictedToActiveSprintValue = this.getTrueOrFalseLabel(isBoard, isRestrictedToActiveSprint);
        model.setRestrictedToActiveSprintValue(isRestrictedToActiveSprintValue);
        SynchronisationStatus synchronisationStatus = sync.getSynchronisationStatus();
        model.setStatus(synchronisationStatus);
        SynchronisationStatus lastSynchronisationStatus = sync.getLastSynchronisationStatus();
        model.setLastStatus(lastSynchronisationStatus);
        model.setProjectId(sync.getProject().getId());
        model.setProjectName(sync.getProject().getName());
        model.setSynchronizedRequirementsCount(sync.getSynchronizedRequirementsCount());
        model.setUnprocessedRequirementsCount(sync.getUnprocessedRequirementsCount());
        this.handleSprintRelatedValues(sync, model, isBoard);
        return model;
    }

    private void handleSprintRelatedValues(JiraRemoteSynchronisation sync, JiraRemoteSynchronisationModel model, boolean isBoard) {
        if (!model.isSprintSynchronisationEnable()) {
            model.setSprintRelatedValuesToNull();
            return;
        }
        model.setSprintAdditionalJQL(sync.getSprintAdditionalJQL());
        model.setSprintSynchronisationPath(sync.getSprintSynchronisationPath());
        boolean isSprintRestrictedToActiveSprint = sync.isSprintRestrictedToActiveSprint();
        model.setSprintRestrictedToActiveSprint(isSprintRestrictedToActiveSprint);
        String isSprintRestrictedToActiveSprintValue = this.getTrueOrFalseLabel(isBoard, isSprintRestrictedToActiveSprint);
        model.setSprintRestrictedToActiveSprintValue(isSprintRestrictedToActiveSprintValue);
        model.setSynchronizedSprintTicketsCount(sync.getSynchronizedSprintTicketsCount());
        model.setUnprocessedSprintTicketsCount(sync.getUnprocessedSprintTicketsCount());
    }

    private String getTrueOrFalseLabel(boolean isBoard, boolean value) {
        Locale locale = LocaleContextHolder.getLocale();
        String response = "";
        if (isBoard) {
            response = value ? this.inHelper.internationalize("label.True", locale) : this.inHelper.internationalize("label.False", locale);
        }
        return response;
    }
}

