/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import java.util.Collection;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicWatchers;
import jirasync.com.atlassian.jira.rest.client.api.domain.Watchers;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicUserJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class WatchersJsonParserBuilder {
    public static JsonObjectParser<Watchers> createWatchersParser() {
        return new JsonObjectParser<Watchers>(){
            private final BasicUserJsonParser userJsonParser = new BasicUserJsonParser();

            @Override
            public Watchers parse(JSONObject json) throws JSONException {
                Collection<BasicUser> watchers = JsonParseUtil.parseJsonArray(json.getJSONArray("watchers"), this.userJsonParser);
                return new Watchers(WatchersJsonParserBuilder.parseValueImpl(json), watchers);
            }
        };
    }

    public static JsonObjectParser<BasicWatchers> createBasicWatchersParser() {
        return new JsonObjectParser<BasicWatchers>(){

            @Override
            public BasicWatchers parse(JSONObject json) throws JSONException {
                return WatchersJsonParserBuilder.parseValueImpl(json);
            }
        };
    }

    private static BasicWatchers parseValueImpl(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        boolean isWatching = json.getBoolean("isWatching");
        int numWatchers = json.getInt("watchCount");
        return new BasicWatchers(self, isWatching, numWatchers);
    }
}

