/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (sync-xsquash4jira) project.
 *     Copyright (C) 2017 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
/*
 * Aggregator for all screen-related resources
 */
define(["./ActionScreen", "./StrategyScreen", "./ByReleaseScreen", "./BySprintScreen", "./JQLScreen",
	"./TicketSelectionScreen", "./TestCaseSelectionScreen", "./IterationScreen", "./DoneScreen"], 
	function(ActionScreen, StrategyScreen, ByReleaseScreen, BySprintScreen, JQLScreen, TicketSelectionScreen, TestCaseSelectionScreen,  
			IterationScreen,  DoneScreen){
	
	
	return {
		// models
		ActionModel 			: ActionScreen.model,
		StrategyModel 			: StrategyScreen.model,
		ByReleaseModel 			: ByReleaseScreen.model,
		BySprintModel 			: BySprintScreen.model,
		JQLModel				: JQLScreen.model,
		TicketSelectionModel 	: TicketSelectionScreen.model,
		TestCaseSelectionModel 	: TestCaseSelectionScreen.model,
		IterationModel 			: IterationScreen.model,
		DoneModel 				: DoneScreen.model,
		
		
		// screens
		ActionScreen 			: ActionScreen.screen,
		StrategyScreen 			: StrategyScreen.screen,
		ProjectSelectionScreen	: ByReleaseScreen.projselScreen,
		ReleaseSelectionScreen	: ByReleaseScreen.relselScreen,
		BoardSelectionScreen 	: BySprintScreen.brdselScreen,
		SprintSelectionScreen 	: BySprintScreen.sprselScreen,
		JQLScreen				: JQLScreen.screen,
		TicketSelectionScreen 	: TicketSelectionScreen.screen,
		TestCaseSelectionScreen : TestCaseSelectionScreen.screen,
		IterationScreen 		: IterationScreen.screen,
		DoneScreen 				: DoneScreen.screen		
		
	};
	
	
});