/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="org.squashtest.tm.plugin.jirasync.ConfigurationManager")
public class ConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final int DEFAULT_BATCH_SIZE = 50;
    private int batchSize = 50;
    @Inject
    private Environment environment;

    @PostConstruct
    public void init() {
        try {
            String property = this.environment.getProperty("plugin.synchronisation.jira.batchSize");
            if (StringUtils.isBlank((CharSequence)property)) {
                this.logDefaultBatchSize();
            } else {
                this.batchSize = Integer.parseInt(property);
                LOGGER.info("[JIRA-SYNC] Configuring batch size to : " + this.batchSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logDefaultBatchSize();
        }
    }

    private void logDefaultBatchSize() {
        LOGGER.warn("[JIRA-SYNC] Error when retrieving the property : plugin.synchronisation.jira.batchSize. The property is either absent or is not a number. Defaulting to : " + this.batchSize);
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

