/*
 * Decompiled with CFR 0.152.
 */
package jirasync.io.atlassian.util.concurrent.atomic;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public abstract class AtomicReferenceUpdater<T>
implements Function<T, T> {
    private final AtomicReference<T> reference;

    public AtomicReferenceUpdater(AtomicReference<T> reference) {
        this.reference = Objects.requireNonNull(reference, "reference");
    }

    public final T update() {
        Object newValue;
        T oldValue;
        do {
            oldValue = this.reference.get();
            newValue = this.apply(oldValue);
        } while (this.reference.get() != oldValue || !this.reference.compareAndSet(oldValue, newValue));
        return (T)newValue;
    }
}

