/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.protocol;

import java.io.IOException;
import jirasync.org.apache.http.HttpEntityEnclosingRequest;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.HttpRequestInterceptor;
import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.protocol.HttpContext;
import jirasync.org.apache.http.protocol.HttpDateGenerator;
import jirasync.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

