/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.sal.api.page;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import jirasync.com.atlassian.sal.api.page.PageCapability;
import jirasync.javax.annotation.Nonnull;
import jirasync.javax.annotation.Nullable;

public abstract class PageCapabilities {
    public static final String SEPARATOR = ",";

    public static EnumSet<PageCapability> empty() {
        return EnumSet.noneOf(PageCapability.class);
    }

    public static EnumSet<PageCapability> valueOf(@Nullable String values) {
        if (values == null || values.length() == 0) {
            return PageCapabilities.empty();
        }
        Collection capabilities = Collections2.filter((Collection)Lists.transform(Arrays.asList(values.split(SEPARATOR)), (Function)new Function<String, PageCapability>(){

            public PageCapability apply(String value) {
                try {
                    return PageCapability.valueOf(value);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull());
        if (capabilities.isEmpty()) {
            return PageCapabilities.empty();
        }
        return EnumSet.copyOf(capabilities);
    }

    public static String toString(@Nonnull EnumSet<PageCapability> pageCaps) {
        return Joiner.on((String)SEPARATOR).join(pageCaps.iterator());
    }
}

