/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jirasync.com.atlassian.jira.rest.client.api.domain.Version;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class VersionJsonParser
implements JsonObjectParser<Version> {
    @Override
    public Version parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        Long id = JsonParseUtil.getOptionalLong(json, "id");
        String name = json.getString("name");
        String description = JsonParseUtil.getOptionalString(json, "description");
        boolean isArchived = json.getBoolean("archived");
        boolean isReleased = json.getBoolean("released");
        String releaseDateStr = JsonParseUtil.getOptionalString(json, "releaseDate");
        DateTime releaseDate = this.parseReleaseDate(releaseDateStr);
        return new Version(self, id, name, description, isArchived, isReleased, releaseDate);
    }

    private DateTime parseReleaseDate(String releaseDateStr) {
        if (releaseDateStr != null) {
            if (releaseDateStr.length() > "YYYY-MM-RR".length()) {
                return JsonParseUtil.parseDateTime(releaseDateStr);
            }
            return JsonParseUtil.parseDate(releaseDateStr);
        }
        return null;
    }
}

