/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (sync-xsquash4jira) project.
 *     Copyright (C) 2017 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["jquery.squash.bindviewformdialog"], function (BindViewFormDialog) {

    var View = BindViewFormDialog.extend({
        el: "#sync-perimeter-dialog-tpl",
        popupSelector: "#sync-perimeter-dialog",

        initialize: function () {
            this.model.url = this.baseUrl()
        },

        baseUrl: function () {
            var globconf = squashtm.plugin.jirasync.conf;
            return squashtm.app.contextRoot + 'jirasync/project/' + globconf.projectId + '/configuration/sync';
        },

        onConfirmSuccess : function(){
            var wreqr  = window.squashtm.app.wreqr

            BindViewFormDialog.prototype.onConfirmSuccess.call(this);
        }

    })

    return View;
});