/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.jsonext;

import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.squashtest.tm.plugin.jirasync.client.JiraReport;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingEffectiveConfiguration;

public class JiraReportParser
implements JsonObjectParser<JiraReport> {
    private JiraReportingEffectiveConfiguration configuration;

    public JiraReportParser(JiraReportingEffectiveConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public JiraReport parse(JSONObject json) throws JSONException {
        String key = json.getString("key");
        JiraReport jiraReport = new JiraReport(this.configuration, key);
        JSONObject fields = json.getJSONObject("fields");
        this.parseStatus(jiraReport, fields);
        this.parseRedactionRate(jiraReport, fields);
        this.parseVerificationRate(jiraReport, fields);
        this.parseValidationRate(jiraReport, fields);
        this.parseRedactionRatio(jiraReport, fields);
        this.parseVerificationRatio(jiraReport, fields);
        this.parseValidationRatio(jiraReport, fields);
        return jiraReport;
    }

    private void parseStatus(JiraReport jiraReport, JSONObject fields) throws JSONException {
        String jiraStatusFieldId = this.configuration.getJiraStatusFieldId();
        if (this.configuration.hasValidStatusField() && fields.has(jiraStatusFieldId)) {
            jiraReport.setInitialStatus(fields.optString(jiraStatusFieldId));
        }
    }

    private void parseRedactionRate(JiraReport jiraReport, JSONObject fields) throws JSONException {
        String redactionProgressFieldId = this.configuration.getJiraRedactionProgressFieldId();
        if (this.configuration.hasValidRedactionField() && fields.has(redactionProgressFieldId)) {
            jiraReport.setInitialRedactionRate(fields.optInt(redactionProgressFieldId));
        }
    }

    private void parseVerificationRate(JiraReport jiraReport, JSONObject fields) throws JSONException {
        String verificationProgressFieldId = this.configuration.getJiraVerificationProgressFieldId();
        if (this.configuration.hasValidVerificationField() && fields.has(verificationProgressFieldId)) {
            jiraReport.setInitialVerificationRate(fields.optInt(verificationProgressFieldId));
        }
    }

    private void parseValidationRate(JiraReport jiraReport, JSONObject fields) throws JSONException {
        String validationRatioFieldId = this.configuration.getJiraValidationRatioFieldId();
        if (this.configuration.hasValidValidationRatioField() && fields.has(validationRatioFieldId)) {
            jiraReport.setInitialValidationRatio(fields.optString(validationRatioFieldId));
        }
    }

    private void parseRedactionRatio(JiraReport jiraReport, JSONObject fields) throws JSONException {
        String redactionRatioFieldId = this.configuration.getJiraRedactionRatioFieldId();
        if (this.configuration.hasValidRedactionRatioField() && fields.has(redactionRatioFieldId)) {
            jiraReport.setInitialRedactionRatio(fields.optString(redactionRatioFieldId));
        }
    }

    private void parseVerificationRatio(JiraReport jiraReport, JSONObject fields) throws JSONException {
        String verificationRatioFieldId = this.configuration.getJiraVerificationRatioFieldId();
        if (this.configuration.hasValidVerificationRatioField() && fields.has(verificationRatioFieldId)) {
            jiraReport.setInitialVerificationRatio(fields.optString(verificationRatioFieldId));
        }
    }

    private void parseValidationRatio(JiraReport jiraReport, JSONObject fields) throws JSONException {
        String validationProgressFieldId = this.configuration.getJiraValidationProgressFieldId();
        if (this.configuration.hasValidValidationField() && fields.has(validationProgressFieldId)) {
            jiraReport.setInitialValidationRate(fields.optInt(validationProgressFieldId));
        }
    }
}

