/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.helpers;

import java.util.ArrayList;
import java.util.List;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueField;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.jirasync.helpers.AbstractValueFinder;
import org.squashtest.tm.plugin.jirasync.helpers.JiraValue;

public class JsonArrayConcatenatedNameValuesFinder
extends AbstractValueFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonArrayConcatenatedNameValuesFinder.class);
    public static final String NAME = "name";

    @Override
    public JiraValue getValue(Object object) {
        if (object == null) {
            return JiraValue.fromStrings(new String[0]);
        }
        try {
            List<String> values = this.getNames((IssueField)object);
            return JiraValue.fromStrings(values);
        }
        catch (ClassCastException e) {
            LOGGER.warn("Expected a JSONArray but got: {}", (Object)object.getClass().getName(), (Object)e);
            return JiraValue.fromStrings(new String[0]);
        }
    }

    private List<String> getNames(IssueField object) {
        JSONArray array = (JSONArray)object.getValue();
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < array.length()) {
            try {
                JSONObject element = array.getJSONObject(i);
                if (element.has(NAME)) {
                    values.add(element.getString(NAME));
                }
            }
            catch (ClassCastException | JSONException e) {
                LOGGER.debug("Could not extract field '{}' from array element: {}", (Object)NAME, (Object)e.getMessage());
            }
            ++i;
        }
        return values;
    }
}

