/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.domain;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.domain.SynchronisationReport;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoard;
import org.squashtest.tm.web.backend.helper.JsonHelper;

public class JiraRemoteSynchronisation {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraRemoteSynchronisation.class);
    public static final String KEY_SYNCHRONISATION_PATH = "synchronisationPath";
    public static final String KEY_ADDITIONAL_JQL = "additionalJQL";
    public static final String KEY_SPRINT_SYNCHRONISATION_ENABLE = "sprintSynchronisationEnable";
    public static final String KEY_SPRINT_ADDITIONAL_JQL = "sprintAdditionalJQL";
    public static final String KEY_SPRINT_SYNCHRONISATION_PATH = "sprintSynchronisationPath";
    public static final String KEY_RESTRICTED_TO_ACTIVE_SPRINT = "restrictedToActiveSprint";
    public static final String KEY_SPRINT_RESTRICTED_TO_ACTIVE_SPRINT = "sprintRestrictedToActiveSprint";
    public static final String KEY_SYNCHRONISATION_ENABLE = "synchronisationEnable";
    public static final String SYNCHRONIZED_REQUIREMENTS_COUNT = "synchronizedRequirementsCount";
    public static final String UNPROCESSED_REQUIREMENTS_COUNT = "unprocessedRequirementsCount";
    public static final String SYNCHRONIZED_SPRINT_TICKETS_COUNT = "synchronizedSprintTicketsCount";
    public static final String UNPROCESSED_SPRINT_TICKETS_COUNT = "unprocessedSprintTicketsCount";
    private final RemoteSynchronisation remoteSynchronisation;
    private JiraBoard board;
    private Long targetFolderId;
    private Long targetSprintGroupId;

    public JiraRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation) {
        this.remoteSynchronisation = remoteSynchronisation;
    }

    public JiraRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation, JiraBoard board) {
        this.remoteSynchronisation = remoteSynchronisation;
        this.board = board;
    }

    public RemoteSynchronisation getRemoteSynchronisation() {
        return this.remoteSynchronisation;
    }

    public void removeSprintSynchronisation() {
        this.removeFromConf(KEY_SPRINT_SYNCHRONISATION_PATH);
        this.removeFromConf(KEY_SPRINT_ADDITIONAL_JQL);
        this.removeFromConf(KEY_SPRINT_RESTRICTED_TO_ACTIVE_SPRINT);
        this.removeFromConf(SYNCHRONIZED_SPRINT_TICKETS_COUNT);
        this.removeFromConf(UNPROCESSED_SPRINT_TICKETS_COUNT);
        this.sprintSynchronisationEnable(false);
    }

    public String getSynchronisationPath() {
        return this.deserializePathOption(KEY_SYNCHRONISATION_PATH);
    }

    public void setSynchronisationPath(String synchronisationPath) {
        this.updateConfiguration(KEY_SYNCHRONISATION_PATH, synchronisationPath);
    }

    public String getSprintSynchronisationPath() {
        return this.deserializePathOption(KEY_SPRINT_SYNCHRONISATION_PATH);
    }

    public void setSprintSynchronisationPath(String sprintSynchronisationPath) {
        this.updateConfiguration(KEY_SPRINT_SYNCHRONISATION_PATH, sprintSynchronisationPath);
    }

    public String getAdditionalJQL() {
        return this.deserializeStringOption(KEY_ADDITIONAL_JQL);
    }

    public void setAdditionalJQL(String jql) {
        this.updateConfiguration(KEY_ADDITIONAL_JQL, jql);
    }

    public String getSprintAdditionalJQL() {
        return this.deserializeStringOption(KEY_SPRINT_ADDITIONAL_JQL);
    }

    public void setSprintAdditionalJQL(String jql) {
        this.updateConfiguration(KEY_SPRINT_ADDITIONAL_JQL, jql);
    }

    public boolean isRestrictedToActiveSprint() {
        return this.deserializeBooleanOption(KEY_RESTRICTED_TO_ACTIVE_SPRINT);
    }

    public boolean isSprintRestrictedToActiveSprint() {
        return this.deserializeBooleanOption(KEY_SPRINT_RESTRICTED_TO_ACTIVE_SPRINT);
    }

    public void restrictedToActiveSprint(boolean restrict) {
        this.updateConfiguration(KEY_RESTRICTED_TO_ACTIVE_SPRINT, restrict);
    }

    public void sprintRestrictedToActiveSprint(boolean restrict) {
        this.updateConfiguration(KEY_SPRINT_RESTRICTED_TO_ACTIVE_SPRINT, restrict);
    }

    public void synchronisationEnable(boolean enable) {
        Map<String, Object> conf = this.getConfForUpdate();
        conf.put(KEY_SYNCHRONISATION_ENABLE, enable);
        this.remoteSynchronisation.setSynchronisationEnable(enable);
    }

    public boolean isSprintSynchronisationEnable() {
        return this.deserializeBooleanOption(KEY_SPRINT_SYNCHRONISATION_ENABLE);
    }

    public void sprintSynchronisationEnable(boolean sprintSyncEnable) {
        this.updateConfiguration(KEY_SPRINT_SYNCHRONISATION_ENABLE, sprintSyncEnable);
    }

    public Integer getSynchronizedRequirementsCount() {
        return this.deserializeIntegerOption(SYNCHRONIZED_REQUIREMENTS_COUNT);
    }

    public Integer getUnprocessedRequirementsCount() {
        return this.deserializeIntegerOption(UNPROCESSED_REQUIREMENTS_COUNT);
    }

    public Integer getSynchronizedSprintTicketsCount() {
        return this.deserializeIntegerOption(SYNCHRONIZED_SPRINT_TICKETS_COUNT);
    }

    public Integer getUnprocessedSprintTicketsCount() {
        return this.deserializeIntegerOption(UNPROCESSED_SPRINT_TICKETS_COUNT);
    }

    public void setSynchronizedAndUnprocessedCounts(SynchronisationReport report) {
        Map<String, Object> conf = this.getConfForUpdate();
        this.updateConfKeyWithIntegerValue(conf, SYNCHRONIZED_REQUIREMENTS_COUNT, report.getSynchronizedRequirementsCount());
        this.updateConfKeyWithIntegerValue(conf, UNPROCESSED_REQUIREMENTS_COUNT, report.getUnprocessedRequirementsCount());
        if (this.isSprintSynchronisationEnable()) {
            this.updateConfKeyWithIntegerValue(conf, SYNCHRONIZED_SPRINT_TICKETS_COUNT, report.getSynchronizedSprintTicketsCount());
            this.updateConfKeyWithIntegerValue(conf, UNPROCESSED_SPRINT_TICKETS_COUNT, report.getUnprocessedSprintTicketsCount());
        }
        this.remoteSynchronisation.setOptions(JsonHelper.serialize(conf));
    }

    public Long getBoardId() {
        if (this.getSelectType().equals(JiraSelectType.BOARD.name())) {
            return this.board.getId();
        }
        throw new IllegalArgumentException("Programmatic error : you should not try to get board id on a no - board synchronisation : " + this.remoteSynchronisation.toString());
    }

    public long getId() {
        return this.remoteSynchronisation.getId();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JiraRemoteSynchronisation{");
        sb.append(this.remoteSynchronisation.toString());
        sb.append('}');
        return sb.toString();
    }

    public String getSelectValue() {
        return this.remoteSynchronisation.getSelectValue();
    }

    public String getSelectType() {
        return this.remoteSynchronisation.getSelectType();
    }

    public BugTracker getServer() {
        return this.remoteSynchronisation.getServer();
    }

    public String getName() {
        return this.remoteSynchronisation.getName();
    }

    public void setSelectValue(String selectValue) {
        this.remoteSynchronisation.setSelectValue(selectValue);
    }

    public void setName(String name) {
        this.remoteSynchronisation.setName(name);
    }

    public void setKind(String kind) {
        this.remoteSynchronisation.setKind(kind);
    }

    public void setSelectType(String selectType) {
        this.remoteSynchronisation.setSelectType(selectType);
    }

    public void setLastSuccessfulSyncDate(Date lastSuccessfulSyncDate) {
        this.remoteSynchronisation.setLastSuccessfulSyncDate(lastSuccessfulSyncDate);
    }

    public void setLastSyncDate(Date lastSyncDate) {
        this.remoteSynchronisation.setLastSyncDate(lastSyncDate);
    }

    public Date getLastSuccessfulSyncDate() {
        return this.remoteSynchronisation.getLastSuccessfulSyncDate();
    }

    public Date getLastSyncDate() {
        return this.remoteSynchronisation.getLastSyncDate();
    }

    public void setProject(Project project) {
        this.remoteSynchronisation.setProject(project);
    }

    public void setOwner(User owner) {
        this.remoteSynchronisation.setOwner(owner);
    }

    public User getOwner() {
        return this.remoteSynchronisation.getOwner();
    }

    public void setServer(BugTracker server) {
        this.remoteSynchronisation.setServer(server);
    }

    public Project getProject() {
        return this.remoteSynchronisation.getProject();
    }

    public boolean isBoard() {
        return this.getSelectType().equals(JiraSelectType.BOARD.toString());
    }

    public boolean mayHaveSprints() {
        return this.board.mayHaveSprints();
    }

    public Long getTargetFolderId() {
        return this.targetFolderId;
    }

    public void setTargetFolderId(Long targetFolderId) {
        this.targetFolderId = targetFolderId;
    }

    public SynchronisationStatus getSynchronisationStatus() {
        return this.remoteSynchronisation.getSynchronisationStatus();
    }

    public SynchronisationStatus getLastSynchronisationStatus() {
        return this.remoteSynchronisation.getLastSynchronisationStatus();
    }

    public boolean isSynchronisationEnable() {
        return this.remoteSynchronisation.isSynchronisationEnable();
    }

    public Long getTargetSprintGroupId() {
        return this.targetSprintGroupId;
    }

    public void setTargetSprintGroupId(Long targetSprintGroupId) {
        this.targetSprintGroupId = targetSprintGroupId;
    }

    public boolean hasOwner() {
        return this.remoteSynchronisation.getOwner() != null;
    }

    private String deserializePathOption(String optionKey) {
        try {
            Map conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
            Object rawPath = conf.get(optionKey);
            if (rawPath == null) {
                throw new IllegalArgumentException("Programmatic error, not key " + optionKey + " in  " + String.valueOf(this.remoteSynchronisation));
            }
            String path = rawPath.toString();
            return PathUtils.appendPathToProjectName((String)this.remoteSynchronisation.getProject().getName(), (String)path);
        }
        catch (Exception e) {
            LOGGER.error("Could not deserialize options for synchronisation " + String.valueOf(this.remoteSynchronisation));
            throw new IllegalArgumentException(e);
        }
    }

    private String deserializeStringOption(String optionKey) {
        Object jql;
        block3: {
            try {
                Map conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
                jql = conf.get(optionKey);
                if (jql != null) break block3;
                return "";
            }
            catch (Exception e) {
                LOGGER.error(String.format("Could not deserialize options for synchronisation %s", this.remoteSynchronisation));
                throw new IllegalArgumentException(e);
            }
        }
        return jql.toString();
    }

    private boolean deserializeBooleanOption(String optionKey) {
        try {
            Map conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
            Object rawOption = conf.get(optionKey);
            return rawOption != null && Boolean.parseBoolean(rawOption.toString());
        }
        catch (Exception e) {
            LOGGER.error("Could not deserialize " + optionKey + "property for synchronisation " + String.valueOf(this.remoteSynchronisation));
            throw new IllegalArgumentException(e);
        }
    }

    private Integer deserializeIntegerOption(String optionKey) {
        Object rawOption;
        block3: {
            try {
                Map conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
                rawOption = conf.get(optionKey);
                if (rawOption != null) break block3;
                return null;
            }
            catch (Exception e) {
                LOGGER.error("Could not deserialize " + optionKey + "property for synchronisation " + String.valueOf(this.remoteSynchronisation));
                throw new IllegalArgumentException(e);
            }
        }
        return Integer.parseInt(rawOption.toString());
    }

    private void updateConfiguration(String key, String value) {
        Map<String, Object> conf = this.getConfForUpdate();
        this.updateConfKey(key, value, conf);
        this.remoteSynchronisation.setOptions(JsonHelper.serialize(conf));
    }

    private void updateConfKey(String key, String value, Map<String, Object> conf) {
        if (StringUtils.isBlank((CharSequence)value)) {
            conf.remove(key);
        } else {
            conf.put(key, value);
        }
    }

    private void updateConfKeyWithIntegerValue(Map<String, Object> conf, String key, int value) {
        String stringValue = String.valueOf(value);
        this.updateConfKey(key, stringValue, conf);
    }

    private void updateConfiguration(String key, boolean value) {
        Map<String, Object> conf = this.getConfForUpdate();
        conf.put(key, value);
        this.remoteSynchronisation.setOptions(JsonHelper.serialize(conf));
    }

    private void removeFromConf(String key) {
        Map<String, Object> conf = this.getConfForUpdate();
        conf.remove(key);
        this.remoteSynchronisation.setOptions(JsonHelper.serialize(conf));
    }

    private Map<String, Object> getConfForUpdate() {
        Map<String, Object> conf;
        if (this.remoteSynchronisation.getOptions() == null) {
            conf = new HashMap<String, Object>();
        } else {
            try {
                conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
            }
            catch (IOException e) {
                LOGGER.error("Could not deserialize options for synchronisation " + String.valueOf(this.remoteSynchronisation));
                throw new IllegalArgumentException(e);
            }
        }
        return conf;
    }
}

