/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.controller.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.service.internal.dto.RawValueModel;

public class IterationFormModel {
    private String name;
    private String reference;
    private String description;
    private boolean copyTestPlan;
    private static final String MESSAGE_NOT_BLANK = "message.notBlank";
    private RawValueModel.RawValueModelMap customFields = new RawValueModel.RawValueModelMap();

    public boolean isCopyTestPlan() {
        return this.copyTestPlan;
    }

    public void setCopyTestPlan(boolean copyTestPlan) {
        this.copyTestPlan = copyTestPlan;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RawValueModel.RawValueModelMap getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(RawValueModel.RawValueModelMap customFields) {
        this.customFields = customFields;
    }

    public Iteration getIteration() {
        Iteration newIteration = new Iteration();
        newIteration.setName(this.name);
        newIteration.setDescription(this.description);
        newIteration.setReference(this.reference);
        return newIteration;
    }

    @JsonIgnore
    public Map<Long, RawValue> getCufs() {
        HashMap<Long, RawValue> cufs = new HashMap<Long, RawValue>(this.customFields.size());
        for (Map.Entry entry : this.customFields.entrySet()) {
            cufs.put((Long)entry.getKey(), ((RawValueModel)entry.getValue()).toRawValue());
        }
        return cufs;
    }

    @Deprecated
    public static class IterationFormModelValidator
    implements Validator {
        private MessageSource messageSource;

        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public IterationFormModelValidator(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public boolean supports(Class<?> clazz) {
            return clazz.equals(IterationFormModel.class);
        }

        public void validate(Object target, Errors errors) {
            String notBlank = this.messageSource.getMessage(IterationFormModel.MESSAGE_NOT_BLANK, null, LocaleContextHolder.getLocale());
            IterationFormModel model = (IterationFormModel)target;
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)IterationFormModel.MESSAGE_NOT_BLANK, (String)notBlank);
            for (Map.Entry entry : model.getCustomFields().entrySet()) {
                RawValueModel value = (RawValueModel)entry.getValue();
                if (!value.isEmpty()) continue;
                errors.rejectValue("customFields[" + String.valueOf(entry.getKey()) + "]", IterationFormModel.MESSAGE_NOT_BLANK, notBlank);
            }
        }
    }
}

