/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.client;

import jakarta.inject.Inject;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraReportTestingStatus;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingEffectiveConfiguration;
import org.squashtest.tm.service.statistics.requirement.RequirementVersionBundleStat;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Configurable
public class JiraReport
implements ConfigurableObject {
    private static final Logger LOGGER;
    private static final String RATIO_PATTERN = "%d%% (%d/%d)";
    private JiraReportingEffectiveConfiguration effectiveConfiguration;
    private String key;
    private String statusValue;
    private JiraReportTestingStatus status;
    private Integer redactionRate;
    private Integer verificationRate;
    private Integer validationRate;
    private String redactionRatio;
    private String verificationRatio;
    private String validationRatio;
    private boolean shouldPostStatus;
    private boolean shouldPostRedactionRate;
    private boolean shouldPostVerificationRate;
    private boolean shouldPostValidationRate;
    private boolean shouldPostRedactionRatio;
    private boolean shouldPostVerificationRatio;
    private boolean shouldPostValidationRatio;
    private String initialStatus;
    private Integer initialRedactionRate;
    private Integer initialVerificationRate;
    private Integer initialValidationRate;
    private String initialRedactionRatio;
    private String initialVerificationRatio;
    private String initialValidationRatio;
    @Inject
    private InternationalizationHelper inHelper;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        JiraReport.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JiraReport.class);
    }

    public JiraReport(JiraReportingEffectiveConfiguration effectiveConfiguration, String key) {
        JiraReportingEffectiveConfiguration jiraReportingEffectiveConfiguration = effectiveConfiguration;
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)jiraReportingEffectiveConfiguration, (Object)string);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.initialStatus = "";
        this.initialRedactionRate = -1;
        this.initialVerificationRate = -1;
        this.initialValidationRate = -1;
        this.initialRedactionRatio = "";
        this.initialVerificationRatio = "";
        this.initialValidationRatio = "";
        this.effectiveConfiguration = effectiveConfiguration;
        this.key = key;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getRedactionRate() {
        return this.redactionRate;
    }

    public void setRedactionRate(Integer redactionRate) {
        this.redactionRate = redactionRate;
    }

    public Integer getVerificationRate() {
        return this.verificationRate;
    }

    public void setVerificationRate(Integer verificationRate) {
        this.verificationRate = verificationRate;
    }

    public Integer getValidationRate() {
        return this.validationRate;
    }

    public void setValidationRate(Integer validationRate) {
        this.validationRate = validationRate;
    }

    public Integer getInitialRedactionRate() {
        return this.initialRedactionRate;
    }

    public void setInitialRedactionRate(Integer initialRedactionRate) {
        this.initialRedactionRate = initialRedactionRate;
    }

    public Integer getInitialVerificationRate() {
        return this.initialVerificationRate;
    }

    public void setInitialVerificationRate(Integer initialVerificationRate) {
        this.initialVerificationRate = initialVerificationRate;
    }

    public Integer getInitialValidationRate() {
        return this.initialValidationRate;
    }

    public void setInitialValidationRate(Integer initialValidationRate) {
        this.initialValidationRate = initialValidationRate;
    }

    public String getInitialStatus() {
        return this.initialStatus;
    }

    public void setInitialStatus(String initialStatus) {
        this.initialStatus = initialStatus;
    }

    public String getStatusValue() {
        return this.statusValue;
    }

    public void setStatusValue(String statusValue) {
        this.statusValue = statusValue;
    }

    public String getRedactionRatio() {
        return this.redactionRatio;
    }

    public void setRedactionRatio(String redactionRatio) {
        this.redactionRatio = redactionRatio;
    }

    public String getVerificationRatio() {
        return this.verificationRatio;
    }

    public void setVerificationRatio(String verificationRatio) {
        this.verificationRatio = verificationRatio;
    }

    public String getValidationRatio() {
        return this.validationRatio;
    }

    public void setValidationRatio(String validationRatio) {
        this.validationRatio = validationRatio;
    }

    public String getInitialRedactionRatio() {
        return this.initialRedactionRatio;
    }

    public void setInitialRedactionRatio(String initialRedactionRatio) {
        this.initialRedactionRatio = initialRedactionRatio;
    }

    public String getInitialVerificationRatio() {
        return this.initialVerificationRatio;
    }

    public void setInitialVerificationRatio(String initialVerificationRatio) {
        this.initialVerificationRatio = initialVerificationRatio;
    }

    public String getInitialValidationRatio() {
        return this.initialValidationRatio;
    }

    public void setInitialValidationRatio(String initialValidationRatio) {
        this.initialValidationRatio = initialValidationRatio;
    }

    public boolean shouldPostStatus() {
        return this.shouldPostStatus;
    }

    public boolean shouldPostRedactionRate() {
        return this.shouldPostRedactionRate;
    }

    public boolean shouldPostVerificationRate() {
        return this.shouldPostVerificationRate;
    }

    public boolean shouldPostValidationRate() {
        return this.shouldPostValidationRate;
    }

    public boolean shouldPostRedactionRatio() {
        return this.shouldPostRedactionRatio;
    }

    public boolean shouldPostVerificationRatio() {
        return this.shouldPostVerificationRatio;
    }

    public boolean shouldPostValidationRatio() {
        return this.shouldPostValidationRatio;
    }

    public boolean shouldBePostToJIRA() {
        return this.shouldPostStatus || this.shouldPostRedactionRate || this.shouldPostValidationRate || this.shouldPostVerificationRate || this.shouldPostRedactionRatio || this.shouldPostVerificationRatio || this.shouldPostValidationRatio;
    }

    public void performStatReconciliation(RemoteRequirementStatistics stats) {
        this.performRedactionRateReconciliation(Double.valueOf(stats.redactionRate.percentRoundedRate));
        this.performVerificationRateReconciliation(Double.valueOf(stats.verificationRate.percentRoundedRate));
        this.performValidationRateReconciliation(Double.valueOf(stats.validationRate.percentRoundedRate));
        this.performRedactionRatioReconciliation(stats.redactionRate.matchingCount, stats.redactionRate.totalCount);
        this.performVerificationRatioReconciliation(stats.verificationRate.matchingCount, stats.verificationRate.totalCount);
        this.performValidationRatioReconciliation(stats.validationRate.matchingCount, stats.validationRate.totalCount);
        this.performStatusComputation();
    }

    public void performStatReconciliation(RequirementVersionBundleStat.SimpleRequirementStats stats) {
        this.performRedactionRateReconciliation(stats.getRedactionRate());
        this.performVerificationRateReconciliation(stats.getVerificationRate());
        this.performValidationRateReconciliation(stats.getValidationRate());
        this.performRedactionRatioReconciliation(stats.getRedactedTestCase(), stats.getAllTestCaseCount());
        this.performVerificationRatioReconciliation(stats.getVerifiedTestCase(), stats.getPlannedTestCase());
        this.performValidationRatioReconciliation(stats.getValidatedTestCase(), stats.getExecutedTestCase());
        this.performStatusComputation();
    }

    private void makeStatusValue() {
        this.statusValue = this.status.getJiraMarkdownIcon() + " " + this.inHelper.internationalize("henix.jirasync.reporting.testing.status." + this.status.name(), Locale.getDefault());
        boolean bl = this.shouldPostStatus = StringUtils.isBlank((CharSequence)this.initialStatus) || !this.initialStatus.equals(this.statusValue);
        if (this.shouldPostStatus && LOGGER.isDebugEnabled()) {
            String message = String.format("[JIRA-SYNC] - For Issue %s Testing Status was : %s and is now %s. Will update.", this.key, this.initialStatus, this.statusValue);
            LOGGER.debug(message);
        }
    }

    private void performValidationRateReconciliation(Double validationRate) {
        this.validationRate = (int)Math.round(validationRate);
        if ((this.effectiveConfiguration.hasValidValidationField() || this.effectiveConfiguration.hasValidStatusField()) && !this.initialValidationRate.equals(this.validationRate) && this.effectiveConfiguration.hasValidValidationField()) {
            if (LOGGER.isDebugEnabled()) {
                String message = String.format("[JIRA-SYNC] - For Issue %s Validation Rate was : %d and is now %d. Will update.", this.key, this.initialValidationRate, this.validationRate);
                LOGGER.debug(message);
            }
            this.shouldPostValidationRate = true;
        }
    }

    private void performVerificationRateReconciliation(Double verificationRate) {
        this.verificationRate = (int)Math.round(verificationRate);
        if ((this.effectiveConfiguration.hasValidVerificationField() || this.effectiveConfiguration.hasValidStatusField()) && !this.initialVerificationRate.equals(this.verificationRate) && this.effectiveConfiguration.hasValidVerificationField()) {
            if (LOGGER.isDebugEnabled()) {
                String message = String.format("[JIRA-SYNC] - For Issue %s Verification Rate was : %d and is now %d. Will update.", this.key, this.initialVerificationRate, this.verificationRate);
                LOGGER.debug(message);
            }
            this.shouldPostVerificationRate = true;
        }
    }

    private void performRedactionRateReconciliation(Double redactionRate) {
        this.redactionRate = (int)Math.round(redactionRate);
        if ((this.effectiveConfiguration.hasValidRedactionField() || this.effectiveConfiguration.hasValidStatusField()) && !this.initialRedactionRate.equals(this.redactionRate) && this.effectiveConfiguration.hasValidRedactionField()) {
            if (LOGGER.isDebugEnabled()) {
                String message = String.format("[JIRA-SYNC] - For Issue %s Redaction Rate was : %d and is now %d. Will update.", this.key, this.initialRedactionRate, this.redactionRate);
                LOGGER.debug(message);
            }
            this.shouldPostRedactionRate = true;
        }
    }

    private void performRedactionRatioReconciliation(Integer countMatching, Integer countAll) {
        this.redactionRatio = String.format(RATIO_PATTERN, this.redactionRate, countMatching, countAll);
        if (this.effectiveConfiguration.hasValidRedactionRatioField() && !this.initialRedactionRatio.equals(this.redactionRatio)) {
            LOGGER.debug("[JIRA-SYNC] - For Issue {} Redaction Ratio was : {} and is now {}. Will update.", new Object[]{this.key, this.initialRedactionRatio, this.redactionRatio});
            this.shouldPostRedactionRatio = true;
        }
    }

    private void performVerificationRatioReconciliation(Integer countMatching, Integer countAll) {
        this.verificationRatio = String.format(RATIO_PATTERN, this.verificationRate, countMatching, countAll);
        if (this.effectiveConfiguration.hasValidVerificationRatioField() && !this.initialVerificationRatio.equals(this.verificationRatio)) {
            LOGGER.debug("[JIRA-SYNC] - For Issue {} Verification Ratio was : {} and is now {}. Will update.", new Object[]{this.key, this.initialVerificationRatio, this.verificationRatio});
            this.shouldPostVerificationRatio = true;
        }
    }

    private void performValidationRatioReconciliation(Integer countMatching, Integer countAll) {
        this.validationRatio = String.format(RATIO_PATTERN, this.validationRate, countMatching, countAll);
        if (this.effectiveConfiguration.hasValidValidationRatioField() && !this.initialValidationRatio.equals(this.validationRatio)) {
            LOGGER.debug("[JIRA-SYNC] - For Issue {} Validation Ratio was : {} and is now {}. Will update.", new Object[]{this.key, this.initialValidationRatio, this.validationRatio});
            this.shouldPostValidationRatio = true;
        }
    }

    private void performStatusComputation() {
        if (this.effectiveConfiguration.hasValidStatusField()) {
            this.status = this.findStatus();
            this.makeStatusValue();
        }
    }

    private JiraReportTestingStatus findStatus() {
        JiraReportTestingStatus status;
        if (this.isZero(this.redactionRate.intValue()) && this.isZero(this.verificationRate.intValue()) && this.isZero(this.validationRate.intValue())) {
            status = JiraReportTestingStatus.NOT_INITIALIZED;
        } else if (this.isIntermediateValue(this.redactionRate.intValue()) && this.isZero(this.verificationRate.intValue()) && this.isZero(this.validationRate.intValue())) {
            status = JiraReportTestingStatus.CONCEPTION;
        } else if (this.isCompleteValue(this.redactionRate.intValue()) && this.isZero(this.verificationRate.intValue()) && this.isZero(this.validationRate.intValue())) {
            status = JiraReportTestingStatus.TO_EXECUTE;
        } else if (this.isIntermediateValue(this.verificationRate.intValue()) && this.isCompleteValue(this.validationRate.intValue())) {
            status = JiraReportTestingStatus.VALIDATION_IN_PROGRESS;
        } else if (this.isStartedValue(this.verificationRate.intValue()) && this.isNotCompleteValue(this.validationRate.intValue())) {
            status = JiraReportTestingStatus.INVALID;
        } else if (this.isCompleteValue(this.validationRate.intValue()) && this.isCompleteValue(this.validationRate.intValue())) {
            status = JiraReportTestingStatus.VALID;
        } else {
            String msg = String.format("Programmatic error. Unable to compute proper status for reporting to issue %s. Rates are %f , %f , %f .", this.key, this.redactionRate, this.verificationRate, this.validationRate);
            throw new IllegalArgumentException(msg);
        }
        return status;
    }

    private boolean isNotCompleteValue(double rate) {
        return rate < 100.0;
    }

    private boolean isCompleteValue(double rate) {
        return rate == 100.0;
    }

    private boolean isZero(double rate) {
        return rate == 0.0;
    }

    private boolean isIntermediateValue(double rate) {
        return rate > 0.0 && rate < 100.0;
    }

    private boolean isStartedValue(double rate) {
        return rate > 0.0;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JiraReport.java", JiraReport.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 72);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.squashtest.tm.plugin.jirasync.client.JiraReport", "org.squashtest.tm.plugin.jirasync.service.JiraReportingEffectiveConfiguration:java.lang.String", "effectiveConfiguration:key", ""), 72);
    }
}

