/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.codehaus.jettison;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import jirasync.org.codehaus.jettison.Convention;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class Node {
    JSONObject object;
    Map attributes;
    Map namespaces;
    Iterator keys;
    QName name;
    JSONArray array;
    int arrayIndex;
    String currentKey;

    public Node(String name, JSONObject object, Convention con) throws JSONException, XMLStreamException {
        this.object = object;
        this.namespaces = new HashMap();
        this.attributes = new HashMap();
        con.processAttributesAndNamespaces(this, object);
        this.keys = object.keys();
        this.name = con.createQName(name, this);
    }

    public Node(String name, Convention con) throws XMLStreamException {
        this.name = con.createQName(name, this);
        this.namespaces = new HashMap();
        this.attributes = new HashMap();
    }

    public Node(JSONObject object) {
        this.object = object;
        this.namespaces = new HashMap();
        this.attributes = new HashMap();
    }

    public int getNamespaceCount() {
        return this.namespaces.size();
    }

    public String getNamespaceURI(String prefix) {
        return (String)this.namespaces.get(prefix);
    }

    public String getNamespaceURI(int index) {
        if (index < 0 || index >= this.getNamespaceCount()) {
            throw new IllegalArgumentException("Illegal index: element has " + this.getNamespaceCount() + " namespace declarations");
        }
        Iterator itr = this.namespaces.values().iterator();
        while (--index >= 0) {
            itr.next();
        }
        return itr.next().toString();
    }

    public String getNamespacePrefix(String URI2) {
        Iterator nsItr = this.namespaces.entrySet().iterator();
        while (nsItr.hasNext()) {
            Map.Entry e = nsItr.next();
            if (!e.getValue().equals(URI2)) continue;
            return (String)e.getKey();
        }
        return null;
    }

    public String getNamespacePrefix(int index) {
        if (index < 0 || index >= this.getNamespaceCount()) {
            throw new IllegalArgumentException("Illegal index: element has " + this.getNamespaceCount() + " namespace declarations");
        }
        Iterator itr = this.namespaces.keySet().iterator();
        while (--index >= 0) {
            itr.next();
        }
        return itr.next().toString();
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }

    public void setNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttribute(QName name, String value) {
        this.attributes.put(name, value);
    }

    public Iterator getKeys() {
        return this.keys;
    }

    public QName getName() {
        return this.name;
    }

    public JSONObject getObject() {
        return this.object;
    }

    public void setObject(JSONObject object) {
        this.object = object;
    }

    public JSONArray getArray() {
        return this.array;
    }

    public void setArray(JSONArray array) {
        this.array = array;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public void setArrayIndex(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(String currentKey) {
        this.currentKey = currentKey;
    }
}

