/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.codehaus.jackson.map.deser.std;

import java.io.IOException;
import java.util.EnumMap;
import jirasync.org.codehaus.jackson.JsonParser;
import jirasync.org.codehaus.jackson.JsonProcessingException;
import jirasync.org.codehaus.jackson.JsonToken;
import jirasync.org.codehaus.jackson.map.DeserializationContext;
import jirasync.org.codehaus.jackson.map.JsonDeserializer;
import jirasync.org.codehaus.jackson.map.TypeDeserializer;
import jirasync.org.codehaus.jackson.map.deser.std.StdDeserializer;
import jirasync.org.codehaus.jackson.map.util.EnumResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMapDeserializer
extends StdDeserializer<EnumMap<?, ?>> {
    protected final EnumResolver<?> _enumResolver;
    protected final JsonDeserializer<Object> _valueDeserializer;

    public EnumMapDeserializer(EnumResolver<?> enumRes, JsonDeserializer<Object> valueDes) {
        super(EnumMap.class);
        this._enumResolver = enumRes;
        this._valueDeserializer = valueDes;
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.mappingException(EnumMap.class);
        }
        EnumMap<?, ?> result = this.constructMap();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            Object key = this._enumResolver.findEnum(fieldName);
            if (key == null) {
                throw ctxt.weirdStringException(this._enumResolver.getEnumClass(), "value not one of declared Enum instance names");
            }
            JsonToken t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? null : this._valueDeserializer.deserialize(jp, ctxt);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    private EnumMap<?, ?> constructMap() {
        Class<?> enumCls = this._enumResolver.getEnumClass();
        return new EnumMap(enumCls);
    }
}

