/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.codehaus.jackson.map;

import java.io.IOException;
import java.util.Iterator;
import jirasync.org.codehaus.jackson.JsonParser;
import jirasync.org.codehaus.jackson.JsonStreamContext;
import jirasync.org.codehaus.jackson.JsonToken;
import jirasync.org.codehaus.jackson.map.DeserializationContext;
import jirasync.org.codehaus.jackson.map.JsonDeserializer;
import jirasync.org.codehaus.jackson.map.JsonMappingException;
import jirasync.org.codehaus.jackson.map.RuntimeJsonMappingException;
import jirasync.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingIterator<T>
implements Iterator<T> {
    protected static final MappingIterator<?> EMPTY_ITERATOR = new MappingIterator(null, null, null, null);
    protected final JavaType _type;
    protected final DeserializationContext _context;
    protected final JsonDeserializer<T> _deserializer;
    protected final JsonParser _parser;

    protected MappingIterator(JavaType type, JsonParser jp, DeserializationContext ctxt, JsonDeserializer<?> deser) {
        JsonStreamContext sc;
        this._type = type;
        this._parser = jp;
        this._context = ctxt;
        this._deserializer = deser;
        if (jp != null && jp.getCurrentToken() == JsonToken.START_ARRAY && !(sc = jp.getParsingContext()).inRoot()) {
            jp.clearCurrentToken();
        }
    }

    protected static <T> MappingIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextValue();
        }
        catch (JsonMappingException e) {
            throw new RuntimeJsonMappingException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public T next() {
        try {
            return this.nextValue();
        }
        catch (JsonMappingException e) {
            throw new RuntimeJsonMappingException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNextValue() throws IOException {
        if (this._parser == null) {
            return false;
        }
        JsonToken t = this._parser.getCurrentToken();
        if (t == null) {
            t = this._parser.nextToken();
            if (t == null) {
                this._parser.close();
                return false;
            }
            if (t == JsonToken.END_ARRAY) {
                return false;
            }
        }
        return true;
    }

    public T nextValue() throws IOException {
        T result = this._deserializer.deserialize(this._parser, this._context);
        this._parser.clearCurrentToken();
        return result;
    }
}

