/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import jirasync.com.atlassian.jira.rest.client.api.domain.ProjectRole;
import jirasync.com.atlassian.jira.rest.client.api.domain.RoleActor;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.com.atlassian.jira.rest.client.internal.json.RoleActorJsonParser;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class ProjectRoleJsonParser
implements JsonObjectParser<ProjectRole> {
    private final RoleActorJsonParser roleActorJsonParser;

    public ProjectRoleJsonParser(URI baseJiraUri) {
        this.roleActorJsonParser = new RoleActorJsonParser(baseJiraUri);
    }

    @Override
    public ProjectRole parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        long id = json.getLong("id");
        String name = json.getString("name");
        String description = json.getString("description");
        Optional<?> roleActorsOpt = JsonParseUtil.getOptionalArray(json, "actors");
        ImmutableSet roleActors = roleActorsOpt.isPresent() ? JsonParseUtil.parseJsonArray((JSONArray)roleActorsOpt.get(), this.roleActorJsonParser) : ImmutableSet.of();
        return new ProjectRole(id, self, name, description, (Collection<RoleActor>)roleActors);
    }
}

