/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.httpclient.apache.httpcomponents.proxy;

import com.google.common.collect.Iterables;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyConfig;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyConfigFactory;
import jirasync.com.atlassian.httpclient.api.factory.HttpClientOptions;
import jirasync.io.atlassian.fugue.Option;
import jirasync.org.apache.http.auth.AuthScope;
import jirasync.org.apache.http.auth.Credentials;
import jirasync.org.apache.http.client.CredentialsProvider;
import jirasync.org.apache.http.impl.client.SystemDefaultCredentialsProvider;

public class ProxyCredentialsProvider
implements CredentialsProvider {
    private final SystemDefaultCredentialsProvider delegate;

    private ProxyCredentialsProvider(SystemDefaultCredentialsProvider delegate) {
        this.delegate = delegate;
    }

    public static Option<ProxyCredentialsProvider> build(HttpClientOptions options) {
        Iterable authenticationInfos = Iterables.filter(ProxyConfigFactory.getProxyAuthentication(options), authenticationInfo -> authenticationInfo.getCredentials().isDefined());
        return Iterables.isEmpty((Iterable)authenticationInfos) ? Option.none() : Option.some(ProxyCredentialsProvider.createCredentialProvider(authenticationInfos));
    }

    private static ProxyCredentialsProvider createCredentialProvider(Iterable<ProxyConfig.AuthenticationInfo> authenticationInfos) {
        SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
        for (ProxyConfig.AuthenticationInfo authenticationInfo : authenticationInfos) {
            authenticationInfo.getCredentials().foreach(credentials -> credentialsProvider.setCredentials(authenticationInfo.getAuthScope(), (Credentials)credentials));
        }
        return new ProxyCredentialsProvider(credentialsProvider);
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.delegate.setCredentials(authscope, credentials);
    }

    @Override
    public Credentials getCredentials(AuthScope authscope) {
        return this.delegate.getCredentials(authscope);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

