/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="squash.tm.plugin.jirasync.ReadableProjectsFinder")
@Transactional(readOnly=true)
public class ReadableProjectsFinder {
    private final UserAccountService userAccountService;
    private final CustomProjectFinder projectFinder;

    public ReadableProjectsFinder(UserAccountService userAccountService, CustomProjectFinder projectFinder) {
        this.userAccountService = userAccountService;
        this.projectFinder = projectFinder;
    }

    public List<Long> findAllReadableProjectIdsForCurrentUser() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.projectFinder.findAllReadableIds(currentUser);
    }
}

