/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanRequirement;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.jirasync.service.execplan.ReadableProjectsFinder;
import org.squashtest.tm.plugin.jirasync.service.execplan.SelectedNode;

@Repository(value="squash.tm.plugin.jirasync.execplandao")
public class ExecplanSynchronizationDao {
    private static final String REQUIREMENT_LABEL = "requirement";
    private static final String REMOTE_PROJECT_ID = "remoteProjectId";
    private static final String PROJECT_LABEL = "project";
    private static final String TEST_CASE_ID = "testCaseId";
    private static final String TEST_CASE_NAME = "testCaseName";
    private static final String REFERENCE = "reference";
    private static final String TEST_CASE_REFERENCE = "testCaseReference";
    private static final String REMOTE_REQ_ID = "remoteReqId";
    private static final String REFERENCED_TEST_CASE = "referencedTestCase";
    private static final String REMOTE_ISSUE_ID = "remoteIssueId";
    private static final String FILTER_SYNC_KEY = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync where sync.kind = 'squash.tm.plugin.jirasync' and extender.remoteReqId in (:keys)";
    private static final String FILTER_BUGFIXES_KEY = "select distinct issue.remoteIssueId from Issue issue where issue.remoteIssueId in (:keys)";
    private static final String FILTER_COVERED_REQS = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync inner join extender.requirement req inner join req.versions versions inner join versions.requirementVersionCoverages cov where sync.kind = 'squash.tm.plugin.jirasync' and extender.remoteReqId in (:keys)";
    private static final String LOAD_SELECTED_NODE_CPG = "select c.id, 'campaign', c.name, p.id, p.name from Campaign c join c.project p where c.id = :id";
    private static final String LOAD_SELECTED_NODE_IT = "select  it.id, 'iteration', it.name, p.id, p.name from Iteration it join it.campaign c join c.project p where it.id = :id";
    private static final String FIND_ITERATION_NAMES = "select it.name from Iteration it join it.campaign c where c.id = :id";
    private static final String FIND_ITERATION_CUFS = "select cuf from CustomFieldBinding binding join binding.customField cuf join binding.boundProject project where project.id = ( select cpro.id from Campaign c join c.project cpro where c.id = :cpgId ) and binding.boundEntity = :boundEntity order by binding.position asc";
    private static final String FIND_SYNCED_SERVERS = "select distinct serv from RemoteSynchronisation sync join sync.server serv";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext DSL;
    @Inject
    private ReadableProjectsFinder readableProjectsFinder;

    public List<BugTracker> findAllJiraServers() {
        return this.em.createQuery(FIND_SYNCED_SERVERS).getResultList();
    }

    public BugTracker findServerById(long id) {
        return (BugTracker)this.em.find(BugTracker.class, (Object)id);
    }

    public List<String> findAllSyncedJiraProjects() {
        return this.findJiraProjectsFromExtenders(null);
    }

    public List<String> findAllSyncedJiraProjects(long squashProjectId) {
        return this.findJiraProjectsFromExtenders(squashProjectId);
    }

    public Map<BugTracker, List<String>> findJiraProjectsGroupedByServer(Collection<String> serverKeys, Collection<Long> tmProjectIds) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createTupleQuery();
        Root extenderRoot = query.from(RequirementSyncExtender.class);
        Join syncJoin = extenderRoot.join("remoteSynchronisation");
        Join serverJoin = syncJoin.join("server");
        Join requirementJoin = extenderRoot.join(REQUIREMENT_LABEL);
        query.multiselect(new Selection[]{serverJoin, extenderRoot.get(REMOTE_PROJECT_ID)}).distinct(true).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)syncJoin.get("kind"), (Object)"squash.tm.plugin.jirasync"), extenderRoot.get(REMOTE_PROJECT_ID).in(serverKeys), requirementJoin.get(PROJECT_LABEL).get("id").in(tmProjectIds)}));
        List results = this.em.createQuery(query).getResultList();
        return results.stream().collect(Collectors.groupingBy(tuple -> (BugTracker)tuple.get(0, BugTracker.class), Collectors.mapping(tuple -> (String)tuple.get(1, String.class), Collectors.toList())));
    }

    private List<String> findJiraProjectsFromExtenders(Long squashProjectId) {
        List<Long> readableTmProjectIds;
        List<Long> list = readableTmProjectIds = squashProjectId == null ? this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser() : Collections.singletonList(squashProjectId);
        if (readableTmProjectIds.isEmpty()) {
            return Collections.emptyList();
        }
        String hql = "    SELECT DISTINCT e.remoteProjectId\n    FROM RequirementSyncExtender e\n    JOIN e.remoteSynchronisation s\n    JOIN e.requirement r\n    WHERE s.kind = :kind\n    AND r.project.id IN :readableTmProjectIds\n    ORDER BY e.remoteProjectId ASC\n";
        TypedQuery query = this.em.createQuery(hql, String.class);
        query.setParameter("kind", (Object)"squash.tm.plugin.jirasync");
        query.setParameter("readableTmProjectIds", readableTmProjectIds);
        return query.getResultList();
    }

    public List<String> findAllSyncedBoards() {
        return this.findBoardsFromSync(null);
    }

    public List<String> findAllSyncedBoards(long squashProjectId) {
        return this.findBoardsFromSync(squashProjectId);
    }

    public Map<BugTracker, List<String>> findBoardsGroupedByServer(Collection<String> boardNames) {
        String hql = "SELECT sync.server, sync.selectValue\nFROM RemoteSynchronisation sync\nJOIN sync.server server\nWHERE sync.kind = :pluginId\n  AND sync.selectType = :selectType\n  AND sync.selectValue IN :boardNames\n  AND sync.project.id IN :projectIds\nORDER BY sync.selectValue ASC";
        TypedQuery query = this.em.createQuery(hql, Object[].class);
        query.setParameter("pluginId", (Object)"squash.tm.plugin.jirasync");
        query.setParameter("selectType", (Object)JiraSelectType.BOARD.toString());
        query.setParameter("boardNames", boardNames);
        query.setParameter("projectIds", this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser());
        List results = query.getResultList();
        HashMap<BugTracker, List<String>> result = new HashMap<BugTracker, List<String>>();
        for (Object[] row : results) {
            BugTracker server = (BugTracker)row[0];
            String selectValue = (String)row[1];
            result.computeIfAbsent(server, k -> new ArrayList()).add(selectValue);
        }
        return result;
    }

    private List<String> findBoardsFromSync(Long squashProjectId) {
        List<Long> readableTmProjectIds;
        List<Long> list = readableTmProjectIds = squashProjectId == null ? this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser() : Collections.singletonList(squashProjectId);
        if (readableTmProjectIds.isEmpty()) {
            return Collections.emptyList();
        }
        String hql = "    SELECT DISTINCT r.selectValue\n    FROM RemoteSynchronisation r\n    WHERE r.kind = :kind\n    AND r.selectType = :selectType\n    AND r.project.id IN :readableProjectIds\n    ORDER BY r.selectValue ASC\n";
        TypedQuery query = this.em.createQuery(hql, String.class);
        query.setParameter("kind", (Object)"squash.tm.plugin.jirasync");
        query.setParameter("selectType", (Object)JiraSelectType.BOARD.toString());
        query.setParameter("readableProjectIds", readableTmProjectIds);
        return query.getResultList();
    }

    public List<ExecplanTestCase> findTestCasesCoveringFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptyList();
        }
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createTupleQuery();
        Root tcRoot = query.from(TestCase.class);
        Join coverageJoin = tcRoot.join("requirementVersionCoverages");
        Join versionJoin = coverageJoin.join("verifiedRequirementVersion");
        Join reqJoin = versionJoin.join(REQUIREMENT_LABEL);
        Join syncExtenderJoin = reqJoin.join("syncExtender");
        query.multiselect(new Selection[]{tcRoot.get("id").alias(TEST_CASE_ID), tcRoot.get("name").alias(TEST_CASE_NAME), tcRoot.get(REFERENCE).alias(TEST_CASE_REFERENCE), versionJoin.get("id").alias("requirementVersionId"), versionJoin.get(REFERENCE).alias("requirementVersionReference"), syncExtenderJoin.get(REMOTE_REQ_ID).alias(REMOTE_REQ_ID)});
        query.where((Expression)cb.and((Expression)syncExtenderJoin.get(REMOTE_REQ_ID).in(jiraKeys), (Expression)tcRoot.get(PROJECT_LABEL).get("id").in(this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser())));
        List tuples = this.em.createQuery(query).getResultList();
        Map groupedResult = tuples.stream().collect(Collectors.groupingBy(tuple -> new ExecplanTestCase((Long)tuple.get(TEST_CASE_ID, Long.class), (String)tuple.get(TEST_CASE_NAME, String.class), (String)tuple.get(TEST_CASE_REFERENCE, String.class)), Collectors.mapping(tuple -> new ExecplanRequirement((Long)tuple.get("requirementVersionId", Long.class), (String)tuple.get("requirementVersionReference", String.class), (String)tuple.get(REMOTE_REQ_ID, String.class)), Collectors.toList())));
        return groupedResult.entrySet().stream().map(entry -> {
            ExecplanTestCase testCase = (ExecplanTestCase)entry.getKey();
            testCase.setRequirements((List)entry.getValue());
            return testCase;
        }).collect(Collectors.toList());
    }

    public List<ExecplanTestCase> findTestCasesFixedBy(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptyList();
        }
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createTupleQuery();
        Root execRoot = query.from(Execution.class);
        Join issueJoin = execRoot.join("issues");
        Join testCaseJoin = execRoot.join(REFERENCED_TEST_CASE);
        query.multiselect(new Selection[]{testCaseJoin.get("id").alias(TEST_CASE_ID), testCaseJoin.get("name").alias(TEST_CASE_NAME), testCaseJoin.get(REFERENCE).alias(TEST_CASE_REFERENCE), issueJoin.get(REMOTE_ISSUE_ID).alias(REMOTE_ISSUE_ID)});
        query.where((Expression)cb.and((Expression)issueJoin.get(REMOTE_ISSUE_ID).in(jiraKeys), (Expression)testCaseJoin.get(PROJECT_LABEL).get("id").in(this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser())));
        List tuples = this.em.createQuery(query).getResultList();
        Map groupedResult = tuples.stream().collect(Collectors.groupingBy(tuple -> new ExecplanTestCase((Long)tuple.get(TEST_CASE_ID, Long.class), (String)tuple.get(TEST_CASE_NAME, String.class), (String)tuple.get(TEST_CASE_REFERENCE, String.class)), Collectors.mapping(tuple -> new ExecplanIssue((String)tuple.get(REMOTE_ISSUE_ID, String.class)), Collectors.toList())));
        return groupedResult.entrySet().stream().map(entry -> {
            ExecplanTestCase testCase = (ExecplanTestCase)entry.getKey();
            testCase.setIssues((List)entry.getValue());
            return testCase;
        }).collect(Collectors.toList());
    }

    public Set<String> filterFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_SYNC_KEY).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterBugfixes(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_BUGFIXES_KEY).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterCoveredFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_COVERED_REQS).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Collection<Long> findTestCasesAlreadyPlannedInCampaign(long campaignId) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root itemRoot = query.from(CampaignTestPlanItem.class);
        Join campaignJoin = itemRoot.join("campaign");
        Join testCaseJoin = itemRoot.join(REFERENCED_TEST_CASE);
        query.select((Selection)testCaseJoin.get("id")).distinct(true);
        query.where((Expression)cb.equal((Expression)campaignJoin.get("id"), (Object)campaignId));
        return this.em.createQuery(query).getResultList();
    }

    public Collection<Long> findTestCasesAlreadyPlannedInIteration(long iterationId) {
        String query = "SELECT DISTINCT referencedTestCase.id\nFROM TestPlanItem item\nJOIN item.testPlan plan\nJOIN plan.parentIteration iteration\nJOIN item.referencedTestCase referencedTestCase\nWHERE iteration.id = :iterationId";
        return this.em.createQuery(query, Long.class).setParameter("iterationId", (Object)iterationId).getResultList();
    }

    public List<String> findIterationNamesForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_NAMES).setParameter("id", (Object)campaignId).getResultList();
    }

    public List<CustomField> findIterationCutomfieldsForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_CUFS).setParameter("cpgId", (Object)campaignId).setParameter("boundEntity", (Object)BindableEntity.ITERATION).getResultList();
    }

    public SelectedNode loadSelectedNode(EntityReference reference) {
        Long id = reference.getId();
        String query = null;
        switch (reference.getType()) {
            case CAMPAIGN: {
                query = LOAD_SELECTED_NODE_CPG;
                break;
            }
            case ITERATION: {
                query = LOAD_SELECTED_NODE_IT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Entity Type '" + String.valueOf(reference.getType()) + "' is not yet supported");
            }
        }
        return this.loadSelectedNode(query, id);
    }

    public boolean isWizardEnabledOnProject(long projectId) {
        return (Integer)this.DSL.selectCount().from((TableLike)Tables.LIBRARY_PLUGIN_BINDING).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_ID)).where(Tables.PROJECT.PROJECT_ID.equal((Object)projectId).and(Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_ID.equal((Object)"squash.tm.plugin.jirasync")).and(Tables.LIBRARY_PLUGIN_BINDING.ACTIVE.eq((Object)true))).fetchOne(0, Integer.class) > 0;
    }

    private SelectedNode loadSelectedNode(String hql, Long entityId) {
        Object[] tuple = (Object[])this.em.createQuery(hql).setParameter("id", (Object)entityId).getSingleResult();
        SelectedNode node = new SelectedNode();
        node.setEntityId((Long)tuple[0]);
        node.setType((String)tuple[1]);
        node.setEntityName((String)tuple[2]);
        node.setProjectId((Long)tuple[3]);
        node.setProjectName((String)tuple[4]);
        return node;
    }

    public Map<Long, String> findHighLevelsHavingLinkInVerifiedRequirements(Map<Long, List<String>> remoteKeysByTestCase) {
        ArrayList<Long> testCaseIds = new ArrayList<Long>(remoteKeysByTestCase.keySet());
        Set remoteKeys = remoteKeysByTestCase.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Requirement REQUIREMENT_LINK_HLR = Tables.REQUIREMENT.as("REQUIREMENT_LINK_HLR");
        return this.DSL.selectDistinct((SelectField)org.jooq.impl.DSL.when((Condition)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID).otherwise((Field)REQUIREMENT_LINK_HLR.HIGH_LEVEL_REQUIREMENT_ID).as("HIGH_LEVEL_ID"), (SelectField)org.jooq.impl.DSL.concat((Field[])new Field[]{Tables.REQUIREMENT_VERSION.REFERENCE, org.jooq.impl.DSL.value((String)" - "), Tables.RESOURCE.NAME}).as("REFERENCE")).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID).and(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds))).leftJoin((TableLike)REQUIREMENT_LINK_HLR).on(REQUIREMENT_LINK_HLR.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID).and(REQUIREMENT_LINK_HLR.HIGH_LEVEL_REQUIREMENT_ID.isNotNull())).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)REQUIREMENT_LINK_HLR.HIGH_LEVEL_REQUIREMENT_ID).or(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID))).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(remoteKeys)).fetchMap(org.jooq.impl.DSL.field((String)"HIGH_LEVEL_ID", Long.class), org.jooq.impl.DSL.field((String)"REFERENCE", String.class));
    }

    public List<Long> findTcIdsWhereVerifiedRequirementHavingLink(Long highLevelId, Set<Long> testCaseIds) {
        return this.DSL.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID).and(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds))).where(Tables.REQUIREMENT.RLN_ID.eq((Object)highLevelId).or(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.eq((Object)highLevelId))).fetchInto(Long.class);
    }
}

