/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jirasync.com.atlassian.jira.rest.client.api.domain.Attachment;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicComponent;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicPriority;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicProject;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicVotes;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicWatchers;
import jirasync.com.atlassian.jira.rest.client.api.domain.ChangelogGroup;
import jirasync.com.atlassian.jira.rest.client.api.domain.Comment;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueField;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueFieldId;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueLink;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueType;
import jirasync.com.atlassian.jira.rest.client.api.domain.Operations;
import jirasync.com.atlassian.jira.rest.client.api.domain.Resolution;
import jirasync.com.atlassian.jira.rest.client.api.domain.Status;
import jirasync.com.atlassian.jira.rest.client.api.domain.Subtask;
import jirasync.com.atlassian.jira.rest.client.api.domain.TimeTracking;
import jirasync.com.atlassian.jira.rest.client.api.domain.User;
import jirasync.com.atlassian.jira.rest.client.api.domain.Version;
import jirasync.com.atlassian.jira.rest.client.api.domain.Worklog;
import jirasync.com.atlassian.jira.rest.client.internal.json.AttachmentJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicIssueJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicPriorityJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicProjectJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicVotesJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.ChangelogJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.CommentJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.IssueLinkJsonParserV5;
import jirasync.com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonWeakParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonWeakParserForJsonObject;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonWeakParserForString;
import jirasync.com.atlassian.jira.rest.client.internal.json.OperationsJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.ResolutionJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.StatusJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.SubtaskJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.TimeTrackingJsonParserV5;
import jirasync.com.atlassian.jira.rest.client.internal.json.UserJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import jirasync.com.atlassian.jira.rest.client.internal.json.WorklogJsonParserV5;
import jirasync.com.sun.ws.rs.core.UriBuilder;
import jirasync.javax.annotation.Nullable;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class IssueJsonParser
implements JsonObjectParser<Issue> {
    private static Set<String> SPECIAL_FIELDS = Sets.newHashSet(IssueFieldId.ids());
    public static final String SCHEMA_SECTION = "schema";
    public static final String NAMES_SECTION = "names";
    private final BasicIssueJsonParser basicIssueJsonParser = new BasicIssueJsonParser();
    private final IssueLinkJsonParserV5 issueLinkJsonParserV5 = new IssueLinkJsonParserV5();
    private final BasicVotesJsonParser votesJsonParser = new BasicVotesJsonParser();
    private final StatusJsonParser statusJsonParser = new StatusJsonParser();
    private final JsonObjectParser<BasicWatchers> watchersJsonParser = WatchersJsonParserBuilder.createBasicWatchersParser();
    private final VersionJsonParser versionJsonParser = new VersionJsonParser();
    private final BasicComponentJsonParser basicComponentJsonParser = new BasicComponentJsonParser();
    private final AttachmentJsonParser attachmentJsonParser = new AttachmentJsonParser();
    private final CommentJsonParser commentJsonParser = new CommentJsonParser();
    private final IssueTypeJsonParser issueTypeJsonParser = new IssueTypeJsonParser();
    private final BasicProjectJsonParser projectJsonParser = new BasicProjectJsonParser();
    private final BasicPriorityJsonParser priorityJsonParser = new BasicPriorityJsonParser();
    private final ResolutionJsonParser resolutionJsonParser = new ResolutionJsonParser();
    private final UserJsonParser userJsonParser = new UserJsonParser();
    private final SubtaskJsonParser subtaskJsonParser = new SubtaskJsonParser();
    private final ChangelogJsonParser changelogJsonParser = new ChangelogJsonParser();
    private final OperationsJsonParser operationsJsonParser = new OperationsJsonParser();
    private final JsonWeakParserForString jsonWeakParserForString = new JsonWeakParserForString();
    private static final String FIELDS = "fields";
    private static final String VALUE_ATTR = "value";
    private final JSONObject providedNames;
    private final JSONObject providedSchema;

    public IssueJsonParser() {
        this.providedNames = null;
        this.providedSchema = null;
    }

    public IssueJsonParser(JSONObject providedNames, JSONObject providedSchema) {
        this.providedNames = providedNames;
        this.providedSchema = providedSchema;
    }

    static Iterable<String> parseExpandos(JSONObject json) throws JSONException {
        String expando = json.getString("expand");
        return Splitter.on((char)',').split((CharSequence)expando);
    }

    private <T> Collection<T> parseArray(JSONObject jsonObject, JsonWeakParser<T> jsonParser, String arrayAttribute) throws JSONException {
        JSONArray valueObject = jsonObject.optJSONArray(arrayAttribute);
        if (valueObject == null) {
            return new ArrayList();
        }
        ArrayList<T> res = new ArrayList<T>(valueObject.length());
        for (int i = 0; i < valueObject.length(); ++i) {
            res.add(jsonParser.parse(valueObject.get(i)));
        }
        return res;
    }

    private <T> Collection<T> parseOptionalArrayNotNullable(JSONObject json, JsonWeakParser<T> jsonParser, String ... path) throws JSONException {
        Collection<T> res = this.parseOptionalArray(json, jsonParser, path);
        return res == null ? Collections.emptyList() : res;
    }

    @Nullable
    private <T> Collection<T> parseOptionalArray(JSONObject json, JsonWeakParser<T> jsonParser, String ... path) throws JSONException {
        JSONArray jsonArray = JsonParseUtil.getNestedOptionalArray(json, path);
        if (jsonArray == null) {
            return null;
        }
        ArrayList<T> res = new ArrayList<T>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            res.add(jsonParser.parse(jsonArray.get(i)));
        }
        return res;
    }

    private String getFieldStringValue(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        Object summaryObject = fieldsJson.get(attributeName);
        if (summaryObject instanceof JSONObject) {
            return ((JSONObject)summaryObject).getString(VALUE_ATTR);
        }
        if (summaryObject instanceof String) {
            return (String)summaryObject;
        }
        throw new JSONException("Cannot parse [" + attributeName + "] from available fields");
    }

    private JSONObject getFieldUnisex(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        JSONObject fieldJson = fieldsJson.getJSONObject(attributeName);
        if (fieldJson.has(VALUE_ATTR)) {
            return fieldJson.getJSONObject(VALUE_ATTR);
        }
        return fieldJson;
    }

    @Nullable
    private String getOptionalFieldStringUnisex(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        return JsonParseUtil.getOptionalString(fieldsJson, attributeName);
    }

    private String getFieldStringUnisex(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        Object fieldJson = fieldsJson.get(attributeName);
        if (fieldJson instanceof JSONObject) {
            return ((JSONObject)fieldJson).getString(VALUE_ATTR);
        }
        return fieldJson.toString();
    }

    @Override
    public Issue parse(JSONObject issueJson) throws JSONException {
        Object transitionsObj;
        BasicIssue basicIssue = this.basicIssueJsonParser.parse(issueJson);
        Iterable<String> expandos = IssueJsonParser.parseExpandos(issueJson);
        JSONObject jsonFields = issueJson.getJSONObject(FIELDS);
        JSONObject commentsJson = jsonFields.optJSONObject(IssueFieldId.COMMENT_FIELD.id);
        List<Comment> comments = commentsJson == null ? Collections.emptyList() : this.parseArray(commentsJson, new JsonWeakParserForJsonObject<Comment>(this.commentJsonParser), "comments");
        String summary = this.getFieldStringValue(issueJson, IssueFieldId.SUMMARY_FIELD.id);
        String description = this.getOptionalFieldStringUnisex(issueJson, IssueFieldId.DESCRIPTION_FIELD.id);
        Collection<Attachment> attachments = this.parseOptionalArray(issueJson, new JsonWeakParserForJsonObject<Attachment>(this.attachmentJsonParser), FIELDS, IssueFieldId.ATTACHMENT_FIELD.id);
        Collection<IssueField> fields = this.parseFields(issueJson);
        IssueType issueType = this.issueTypeJsonParser.parse(this.getFieldUnisex(issueJson, IssueFieldId.ISSUE_TYPE_FIELD.id));
        DateTime creationDate = JsonParseUtil.parseDateTime(this.getFieldStringUnisex(issueJson, IssueFieldId.CREATED_FIELD.id));
        DateTime updateDate = JsonParseUtil.parseDateTime(this.getFieldStringUnisex(issueJson, IssueFieldId.UPDATED_FIELD.id));
        String dueDateString = this.getOptionalFieldStringUnisex(issueJson, IssueFieldId.DUE_DATE_FIELD.id);
        DateTime dueDate = dueDateString == null ? null : JsonParseUtil.parseDateTimeOrDate(dueDateString);
        BasicPriority priority = this.getOptionalNestedField(issueJson, IssueFieldId.PRIORITY_FIELD.id, this.priorityJsonParser);
        Resolution resolution = this.getOptionalNestedField(issueJson, IssueFieldId.RESOLUTION_FIELD.id, this.resolutionJsonParser);
        User assignee = this.getOptionalNestedField(issueJson, IssueFieldId.ASSIGNEE_FIELD.id, this.userJsonParser);
        User reporter = this.getOptionalNestedField(issueJson, IssueFieldId.REPORTER_FIELD.id, this.userJsonParser);
        BasicProject project = this.projectJsonParser.parse(this.getFieldUnisex(issueJson, IssueFieldId.PROJECT_FIELD.id));
        Collection<IssueLink> issueLinks = this.parseOptionalArray(issueJson, new JsonWeakParserForJsonObject<IssueLink>(this.issueLinkJsonParserV5), FIELDS, IssueFieldId.LINKS_FIELD.id);
        Collection<Subtask> subtasks = this.parseOptionalArray(issueJson, new JsonWeakParserForJsonObject<Subtask>(this.subtaskJsonParser), FIELDS, IssueFieldId.SUBTASKS_FIELD.id);
        BasicVotes votes = this.getOptionalNestedField(issueJson, IssueFieldId.VOTES_FIELD.id, this.votesJsonParser);
        Status status = this.statusJsonParser.parse(this.getFieldUnisex(issueJson, IssueFieldId.STATUS_FIELD.id));
        Collection<Version> fixVersions = this.parseOptionalArray(issueJson, new JsonWeakParserForJsonObject<Version>(this.versionJsonParser), FIELDS, IssueFieldId.FIX_VERSIONS_FIELD.id);
        Collection<Version> affectedVersions = this.parseOptionalArray(issueJson, new JsonWeakParserForJsonObject<Version>(this.versionJsonParser), FIELDS, IssueFieldId.AFFECTS_VERSIONS_FIELD.id);
        Collection<BasicComponent> components = this.parseOptionalArray(issueJson, new JsonWeakParserForJsonObject<BasicComponent>(this.basicComponentJsonParser), FIELDS, IssueFieldId.COMPONENTS_FIELD.id);
        URI selfUri = basicIssue.getSelf();
        String transitionsUriString = issueJson.has(IssueFieldId.TRANSITIONS_FIELD.id) ? ((transitionsObj = issueJson.get(IssueFieldId.TRANSITIONS_FIELD.id)) instanceof String ? (String)transitionsObj : null) : this.getOptionalFieldStringUnisex(issueJson, IssueFieldId.TRANSITIONS_FIELD.id);
        URI transitionsUri = this.parseTransisionsUri(transitionsUriString, selfUri);
        Collection<Object> worklogs = JsonParseUtil.getNestedOptionalObject(issueJson, FIELDS, IssueFieldId.WORKLOG_FIELD.id) != null ? this.parseOptionalArray(issueJson, new JsonWeakParserForJsonObject<Worklog>(new WorklogJsonParserV5(selfUri)), FIELDS, IssueFieldId.WORKLOG_FIELD.id, IssueFieldId.WORKLOGS_FIELD.id) : Collections.emptyList();
        BasicWatchers watchers = this.getOptionalNestedField(issueJson, IssueFieldId.WATCHER_FIELD.id, this.watchersJsonParser);
        TimeTracking timeTracking = this.getOptionalNestedField(issueJson, IssueFieldId.TIMETRACKING_FIELD.id, new TimeTrackingJsonParserV5());
        HashSet labels = Sets.newHashSet(this.parseOptionalArrayNotNullable(issueJson, this.jsonWeakParserForString, FIELDS, IssueFieldId.LABELS_FIELD.id));
        Collection<ChangelogGroup> changelog = this.parseOptionalArray(issueJson, new JsonWeakParserForJsonObject<ChangelogGroup>(this.changelogJsonParser), "changelog", "histories");
        Operations operations = JsonParseUtil.parseOptionalJsonObject(issueJson, "operations", this.operationsJsonParser);
        return new Issue(summary, selfUri, basicIssue.getKey(), basicIssue.getId(), project, issueType, status, description, priority, resolution, attachments, reporter, assignee, creationDate, updateDate, dueDate, affectedVersions, fixVersions, components, timeTracking, fields, comments, transitionsUri, issueLinks, votes, worklogs, watchers, expandos, subtasks, changelog, operations, labels);
    }

    private URI parseTransisionsUri(String transitionsUriString, URI selfUri) {
        return transitionsUriString != null ? JsonParseUtil.parseURI(transitionsUriString) : UriBuilder.fromUri(selfUri).path("transitions").queryParam("expand", "transitions.fields").build(new Object[0]);
    }

    @Nullable
    private <T> T getOptionalNestedField(JSONObject s, String fieldId, JsonObjectParser<T> jsonParser) throws JSONException {
        JSONObject fieldJson = JsonParseUtil.getNestedOptionalObject(s, FIELDS, fieldId);
        if (fieldJson != null) {
            return jsonParser.parse(fieldJson);
        }
        return null;
    }

    private Collection<IssueField> parseFields(JSONObject issueJson) throws JSONException {
        JSONObject names = this.providedNames != null ? this.providedNames : issueJson.optJSONObject(NAMES_SECTION);
        Map<String, String> namesMap = this.parseNames(names);
        JSONObject schema = this.providedSchema != null ? this.providedSchema : issueJson.optJSONObject(SCHEMA_SECTION);
        Map<String, String> typesMap = this.parseSchema(schema);
        JSONObject json = issueJson.getJSONObject(FIELDS);
        ArrayList<IssueField> res = new ArrayList<IssueField>(json.length());
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value;
                if (SPECIAL_FIELDS.contains(key)) continue;
                res.add(new IssueField(key, namesMap.get(key), typesMap.get("key"), (value = json.opt(key)) != JSONObject.NULL ? value : null));
            }
            catch (Exception e) {
                throw new JSONException("Error while parsing [" + key + "] field: " + e.getMessage()){

                    @Override
                    public Throwable getCause() {
                        return e;
                    }
                };
            }
        }
        return res;
    }

    private Map<String, String> parseSchema(JSONObject json) throws JSONException {
        HashMap res = Maps.newHashMap();
        Iterator<String> it = JsonParseUtil.getStringKeys(json);
        while (it.hasNext()) {
            String fieldId = it.next();
            JSONObject fieldDefinition = json.getJSONObject(fieldId);
            res.put(fieldId, fieldDefinition.getString("type"));
        }
        return res;
    }

    private Map<String, String> parseNames(JSONObject json) throws JSONException {
        HashMap res = Maps.newHashMap();
        Iterator<String> iterator = JsonParseUtil.getStringKeys(json);
        while (iterator.hasNext()) {
            String key = iterator.next();
            res.put(key, json.getString(key));
        }
        return res;
    }
}

