/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (sync-xsquash4jira) project.
 *     Copyright (C) 2017 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(['handlebars', 'squash.translator', 'squash.dateutils',  'app/squash.handlebars.helpers'], function(Handlebars, translator, dateutils){
	
	
	// date formatting
	var dateformat = translator.get('squashtm.dateformatShort.datepicker2');
	
	function reformatDate(atomDate){
		var date = dateutils.parse(atomDate);
		return dateutils.format(date,dateformat);
	}
	
	// *************** handlebar helpers ********************
	
	Handlebars.registerHelper('selected-ifeq', function(id, selectedId, options){
		var selected = (id === selectedId) ? "selected" : "";
		return new Handlebars.SafeString(selected);
	});
	
	Handlebars.registerHelper('radiocheck', function(ctxt, options){
		var checkStr = (this.radiocheck === ctxt) ? 'checked="checked"' : "";
		return new Handlebars.SafeString(checkStr);
	});
	
	Handlebars.registerHelper('disabled', function(ctxt, options){
		var disabled = (this.disabled === true) ? 'disabled="disabled"' : "";
		return new Handlebars.SafeString(disabled);
	});
	
	Handlebars.registerHelper('enabled', function(ctxt, options){
		var enableStr = (this.enabled) ? "opacity : 1.0;" : "opacity : 0.3";
		return new Handlebars.SafeString(enableStr);
	});
	
	Handlebars.registerHelper('pseudo-disabled', function(ctxt, options){
		var pseudoDisabledClss = (this.disabled === true) ? 'jirsync-disabled' : '';
		return new Handlebars.SafeString(pseudoDisabledClss);
	});
	
	Handlebars.registerHelper('todate', function(ctxt, options){
		var strdate = translator.get('henix.jirasync.execplan.designer.messages.unknown');
		if (!! ctxt){
			strdate = reformatDate(ctxt);
		}
		return strdate;
	});
	
	Handlebars.registerHelper('default', function(value, defaultValue, options){
		var finalValue = value || defaultValue;
		return finalValue;
	});
	
	// that one is for printing sprint informations in the SprintSelectionScreen (view 3b)
	Handlebars.registerHelper('stateinfo', function(ctxt, options){
		var output = "";
		switch(ctxt.state){
		case "FUTURE" :
			output = translator.get('henix.jirasync.execplan.designer.sprintstates.future');
			break;
		case "ACTIVE" : 
			output = translator.get('henix.jirasync.execplan.designer.sprintstates.active');
			break;
		case "CLOSED" :
			var atomDate = ctxt.completeDate;
			var strDate;
			if (!!atomDate){
				strDate = reformatDate(atomDate);
			}
			else{
				strDate = translator.get('henix.jirasync.execplan.designer.messages.unknown');
			}
				
			return translator.get('henix.jirasync.execplan.designer.sprintstates.closed', strDate);
		}
		return output;
	});
	
	// **************** (advanced) internationalization *************

	
	// let you register a prefix for all i18n keys.
	// that prefix will be used for all keys translated in ci18n.
	Handlebars.registerHelper('seti18nCtxt', function(prefix, options){
		options.data = options.data || {};
		options.data.lang = options.data.lang || {};
		options.data.lang.prefix = prefix;
	});
	
	function safeGetPrefix(options){
		var pref = options.data || {};
		pref = pref.lang || {};
		return pref.prefix;
	}
	
	// that one performs actual translations
	// first argument must be the key.
	// additional arguments are parameters for the key, if it accepts parameters.
	// i18ncontext will be honored if it has been defined.
	Handlebars.registerHelper('ci18n', function(){
		
		var args = Array.prototype.slice.call(arguments);
		var len = args.length;
		
		// get the prefix
		var options = args[len-1];
		var prefix = safeGetPrefix(options);
		
		// prepare the parameters for translator
		var i18nArgs = args.slice(0,len-1);		
		if (!!prefix){
			i18nArgs[0] = prefix+'.'+i18nArgs[0];
		}
		// now invoke translator.get with our dynamic parameters
		return translator.get.apply(translator, i18nArgs);
	});
	
	// same as the helper 'default', but with i18n
	// however it does not support (yet) the parameters
	Handlebars.registerHelper('ci18ndefault', function(value, defaultValue, options){
		var key = value || defaultValue;
		var prefix = safeGetPrefix(options);
		if (!!prefix){
			key = prefix+'.'+key;
		}
		return translator.get(key);
	});

	// *************** partial templates **********************
	
	var ci18nCtxt = $("#jirsync-plan-ci18nCtxt-template").html();
	Handlebars.registerPartial('ci18nCtxt', ci18nCtxt);
	
	var panetitle = $("#jirsync-plan-panetitle-template").html();
	Handlebars.registerPartial('panetitle', panetitle);
	
	var hint = $("#jirsync-plan-hint-template").html();
	Handlebars.registerPartial('hint', hint);
	
	var tgpanel = $("#jirsync-plan-tgpanel-template").html();
	Handlebars.registerPartial('tgpanel', tgpanel);
	
	var collapsedtgpanel = $("#jirsync-plan-collapsed-tgpanel-template").html();
	Handlebars.registerPartial('collapsed-tgpanel', collapsedtgpanel);
	
	var tabfilter = $("#jirsync-plan-tabfilter-template").html();
	Handlebars.registerPartial('tabfilter', tabfilter);
	
	var formfield = $("#jirsync-plan-formfield-template").html();
	Handlebars.registerPartial('formfield', formfield);
	
	var sourcecounter = $("#jirsync-plan-sourcecounter-template").html();
	Handlebars.registerPartial('sourcecounter', sourcecounter);
	
	var csstable = $("#jirsync-plan-csstable-template").html();
	Handlebars.registerPartial('csstable', csstable);
	
	
});