/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirasync.com.atlassian.jira.rest.client.api.domain.Visibility;
import jirasync.com.atlassian.jira.rest.client.api.domain.Worklog;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.com.atlassian.jira.rest.client.internal.json.VisibilityJsonParser;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class WorklogJsonParserV5
implements JsonObjectParser<Worklog> {
    private final URI issue;

    public WorklogJsonParserV5(URI issue) {
        this.issue = issue;
    }

    @Override
    public Worklog parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        BasicUser author = JsonParseUtil.parseBasicUser(json.optJSONObject("author"));
        BasicUser updateAuthor = JsonParseUtil.parseBasicUser(json.optJSONObject("updateAuthor"));
        String comment = json.optString("comment");
        DateTime creationDate = JsonParseUtil.parseDateTime(json, "created");
        DateTime updateDate = JsonParseUtil.parseDateTime(json, "updated");
        DateTime startDate = JsonParseUtil.parseDateTime(json, "started");
        int secondsSpent = json.optInt("timeSpentSeconds", 0);
        Visibility visibility = new VisibilityJsonParser().parseVisibility(json);
        return new Worklog(self, this.issue, author, updateAuthor, comment, creationDate, updateDate, startDate, secondsSpent / 60, visibility);
    }
}

