/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.internal.fetcher;

import java.util.concurrent.Executor;
import xsquash4gitlab.com.apollographql.apollo.api.Operation;
import xsquash4gitlab.com.apollographql.apollo.api.Response;
import xsquash4gitlab.com.apollographql.apollo.api.internal.ApolloLogger;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.com.apollographql.apollo.fetcher.ResponseFetcher;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptor;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

public final class CacheOnlyFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheOnlyInterceptor();
    }

    private static final class CacheOnlyInterceptor
    implements ApolloInterceptor {
        private CacheOnlyInterceptor() {
        }

        @Override
        public void interceptAsync(final @NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    callBack.onResponse(this.cacheMissResponse(request.operation));
                    callBack.onCompleted();
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }

                @Override
                public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                    callBack.onFetch(sourceType);
                }
            });
        }

        @Override
        public void dispose() {
        }

        ApolloInterceptor.InterceptorResponse cacheMissResponse(Operation operation) {
            return new ApolloInterceptor.InterceptorResponse(null, Response.builder(operation).fromCache(true).build(), null);
        }
    }
}

