/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractNoteFormatter {
    private static final String SUBSTITUTOR_PREFIX = "{{";
    private static final String SUBSTITUTOR_SUFFIX = "}}";
    protected final EnumMap<LocaleCode, String> templateByLocaleCode = new EnumMap(LocaleCode.class);

    protected String substituteParameters(Map<String, String> parameters, LocaleCode localeCode) {
        StringSubstitutor sub = new StringSubstitutor(parameters, SUBSTITUTOR_PREFIX, SUBSTITUTOR_SUFFIX);
        return sub.replace(this.templateByLocaleCode.get((Object)localeCode));
    }

    protected void loadTemplates(String dataPathFormat) {
        this.templateByLocaleCode.clear();
        Arrays.stream(LocaleCode.values()).forEach(localeCode -> {
            try {
                String resourcePath = dataPathFormat.formatted(localeCode.fileNameSuffix);
                Resource resource = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader()).getResource(resourcePath);
                String fileContent = new String(resource.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                this.templateByLocaleCode.put((LocaleCode)((Object)localeCode), fileContent);
            }
            catch (IOException ioException) {
                throw new IllegalStateException(String.format("Error while loading the report note template for locale %s. Make sure the template file exists.", localeCode.fileNameSuffix), ioException);
            }
        });
    }

    public static enum LocaleCode {
        FR("fr"),
        EN("en");

        public final String fileNameSuffix;

        private LocaleCode(String fileNameSuffix) {
            this.fileNameSuffix = fileNameSuffix;
        }
    }
}

