/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.execplan;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.execPlan.IssueRequestModel;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.execPlan.IterationFormMetadata;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.DummyGitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.ExecPlanSpecification;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSelectType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.PerimeterType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanGitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientProvider;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.IssueFetchResult;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabPerimeterService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.ExecPlanSynchronizationDao;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.ExecPlanTestplanService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.ExecplanTestCaseService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.SelectedNode;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;

@Service(value="squash.tm.plugin.xsquash4gitlab.explanSyncService")
@Transactional
public class ExecPlanSynchronizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecPlanSynchronizationService.class);
    @Inject
    private ExecPlanSynchronizationDao execPlanSynchronizationDao;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private ExecPlanTestplanService execPlanTestplanService;
    @Inject
    private GitLabClientProvider gitLabClientProvider;
    @Inject
    private GitLabPerimeterService gitLabPerimeterService;
    @Inject
    private ExecplanTestCaseService testcaseService;
    @Inject
    private ExecPlanTestplanService testplanService;

    @Transactional(readOnly=true)
    public SelectedNode createSelectedNode(EntityReference reference) {
        return this.execPlanSynchronizationDao.loadSelectedNode(reference);
    }

    public boolean isWizardEnabledOnProject(long projectId) {
        return this.execPlanSynchronizationDao.isWizardEnabledOnProject(projectId);
    }

    @Transactional(readOnly=true)
    public List<BugTracker> findAllSyncedGitLabServers() {
        LOGGER.debug("retrieving every synchronized GitLab servers");
        return this.execPlanSynchronizationDao.findAllGitLabServers();
    }

    @Transactional(readOnly=true)
    public IterationFormMetadata findIterationMetadataForCampaign(Long campaignId) {
        LOGGER.debug("retrieving iteration creation metadata");
        return this.execPlanTestplanService.getIterationMetadata(campaignId);
    }

    public Set<String> getExistingPerimetersByProjectId(Long projectId) {
        List remoteSynchronisations = this.remoteSynchronisationDao.findByProjectIdAndKind(projectId, "squash.tm.plugin.xsquash4gitlab");
        ArrayList gitLabRemoteSynchronisations = new ArrayList();
        remoteSynchronisations.forEach(remoteSync -> {
            GitLabRemoteSynchronisation gitLabSync = new GitLabRemoteSynchronisation((RemoteSynchronisation)remoteSync);
            gitLabRemoteSynchronisations.add(gitLabSync);
        });
        HashSet<String> perimeters = new HashSet<String>();
        gitLabRemoteSynchronisations.forEach(gitLabRemoteSynchronisation -> {
            boolean bl = perimeters.add(gitLabRemoteSynchronisation.getPerimeter());
        });
        return perimeters;
    }

    public List<ExecplanGitLabIssue> getGitLabIssuesInPerimeter(IssueRequestModel requestModel) {
        GitLabClient client = this.gitLabClientProvider.getGitLabClient(requestModel.getServerId());
        PerimeterType perimeterType = this.gitLabPerimeterService.getPerimeterType(client, requestModel.getPerimeter());
        DummyGitLabRemoteSynchronisation dummySynchronisation = new DummyGitLabRemoteSynchronisation(requestModel);
        IssueFetchResult fetchResult = PerimeterType.PROJECT.equals((Object)perimeterType) ? this.getGitLabIssuesInProject(dummySynchronisation, client, requestModel) : this.getGitLabIssuesInGroup(dummySynchronisation, client, requestModel);
        return this.convertToGitLabIssueDto(fetchResult);
    }

    private IssueFetchResult getGitLabIssuesInProject(DummyGitLabRemoteSynchronisation synchronisation, GitLabClient client, IssueRequestModel requestModel) {
        boolean selectByBoard = GitLabRemoteSelectType.BOARD.name().equals(requestModel.getRemoteSelectType());
        return selectByBoard ? client.getProjectClient().getBoardIssues(synchronisation, false) : client.getProjectClient().getProjectIssues(synchronisation);
    }

    private IssueFetchResult getGitLabIssuesInGroup(DummyGitLabRemoteSynchronisation synchronisation, GitLabClient client, IssueRequestModel requestModel) {
        boolean selectByBoard = GitLabRemoteSelectType.BOARD.name().equals(requestModel.getRemoteSelectType());
        return selectByBoard ? client.getGroupClient().getBoardIssues(synchronisation, false) : client.getGroupClient().getIssues(synchronisation);
    }

    private List<ExecplanGitLabIssue> convertToGitLabIssueDto(IssueFetchResult fetchResult) {
        ArrayList<ExecplanGitLabIssue> execplanGitLabIssues = new ArrayList<ExecplanGitLabIssue>();
        fetchResult.gitLabIssues.forEach(gitLabIssue -> {
            ExecplanGitLabIssue dto = new ExecplanGitLabIssue(gitLabIssue.getId(), this.formatReference((GitLabIssue)gitLabIssue), gitLabIssue.getWebUrl(), gitLabIssue.getTitle(), gitLabIssue.getLabels(), gitLabIssue.getAssignees());
            execplanGitLabIssues.add(dto);
        });
        this.testcaseService.partitionGitLabIssues(execplanGitLabIssues);
        return execplanGitLabIssues;
    }

    private String formatReference(GitLabIssue gitLabIssue) {
        return "%s#%s".formatted(gitLabIssue.getProjectPath(), gitLabIssue.getIid());
    }

    @Transactional(readOnly=true)
    public List<ExecplanTestCase> findCandidateTestCasesForIssues(List<ExecplanGitLabIssue> issues) {
        LOGGER.debug("retrieving test cases for issues");
        return this.testcaseService.findTestCasesForIssues(issues);
    }

    public void updateCampaignTestPlan(ExecPlanSpecification specification) {
        this.testplanService.updateCampaignTestPlan(specification);
    }

    public void updateIterationTestPlan(ExecPlanSpecification specification) {
        this.testplanService.updateIterationTestPlan(specification);
    }

    public Iteration createIteration(ExecPlanSpecification specification) {
        return this.testplanService.createIteration(specification);
    }
}

