/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.BoardsByPerimeterByBugTrackerDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.ConfigurationPageDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.SynchronisationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabField;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.UserConfiguration;
import org.squashtest.tm.plugin.xsquash4gitlab.helpers.RemoteTestingStatusLabelHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.FieldMappingService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabPerimeterService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.UserConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.webhook.WebhookSecretTokenProvider;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatus;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Service(value="squash.tm.plugin.xsquash4gitlab.configurationDisplayService")
@Transactional
public class ConfigurationDisplayService {
    private static final String BUGTRACKER_KIND = "gitlab.bugtracker";
    private static final String LANG_FIELD_PREFIX = "henix.xsquash4gitlab.fields.";
    private static final Logger LOGGER = LoggerFactory.getLogger(CallbackUrlProvider.class);
    private final BugTrackerManagerService bugTrackerManagerService;
    private final ConfigurationService configurationService;
    private final InternationalizationHelper i18nhelper;
    private final CustomFieldBindingFinderService cufService;
    private final UserConfigurationService userConfigurationService;
    private final GenericProjectFinder genericProjectFinder;
    private final FieldMappingService fieldMappingService;
    private final GitLabPerimeterService gitLabPerimeterService;
    private final CallbackUrlProvider callbackUrlProvider;
    private final WebhookSecretTokenProvider webhookSecretTokenProvider;
    private final GenericProjectDao genericProjectDao;
    private final TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService;

    public ConfigurationDisplayService(BugTrackerManagerService bugTrackerManagerService, ConfigurationService configurationService, InternationalizationHelper i18nhelper, CustomFieldBindingFinderService cufService, UserConfigurationService userConfigurationService, GenericProjectFinder genericProjectFinder, FieldMappingService fieldMappingService, GitLabPerimeterService gitLabPerimeterService, CallbackUrlProvider callbackUrlProvider, WebhookSecretTokenProvider webhookSecretTokenProvider, GenericProjectDao genericProjectDao, TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService) {
        this.bugTrackerManagerService = bugTrackerManagerService;
        this.configurationService = configurationService;
        this.i18nhelper = i18nhelper;
        this.cufService = cufService;
        this.userConfigurationService = userConfigurationService;
        this.genericProjectFinder = genericProjectFinder;
        this.fieldMappingService = fieldMappingService;
        this.gitLabPerimeterService = gitLabPerimeterService;
        this.callbackUrlProvider = callbackUrlProvider;
        this.webhookSecretTokenProvider = webhookSecretTokenProvider;
        this.genericProjectDao = genericProjectDao;
        this.templateConfigurablePluginBindingService = templateConfigurablePluginBindingService;
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ConfigurationPageDto getConfigurationPage(Long projectId) {
        List<NamedReference> availableBugtrackers = this.bugTrackerManagerService.findByKind(BUGTRACKER_KIND).stream().map(bt -> new NamedReference(bt.getId(), bt.getName())).sorted((a, b) -> a.getName().compareToIgnoreCase(b.getName())).collect(Collectors.toList());
        String nullServerName = this.i18nhelper.internationalize("label.None", LocaleContextHolder.getLocale());
        NamedReference nullServer = new NamedReference(Long.valueOf(0L), nullServerName);
        availableBugtrackers.add(0, nullServer);
        List<SynchronisationDto> synchronisations = this.configurationService.getRemoteSynchronisationsByProject(projectId);
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        boolean isProjectTemplate = this.genericProjectDao.isProjectTemplate(projectId.longValue());
        boolean isProjectConfigurationBoundToTemplate = this.templateConfigurablePluginBindingService.isProjectConfigurationBoundToTemplate(projectId.longValue(), "squash.tm.plugin.xsquash4gitlab");
        return new ConfigurationPageDto(projectId, isProjectTemplate, isProjectConfigurationBoundToTemplate, availableBugtrackers, synchronisations, this.makeSquashFieldList(projectId), this.makeGitLabFieldList(), userConfiguration, this.makeValueMappingsList(projectId), this.fetchBoardsByPerimeter(synchronisations), this.isCallbackUrlSet() ? this.getCallbackUrl() : null, this.getWebhookSecretTokenIfShown(), this.getLabelSuffixes());
    }

    private Map<String, String> makeSquashFieldList(Long projectId) {
        String code;
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, String> fields = new HashMap<String, String>();
        BuiltinSquashField[] builtinSquashFieldArray = BuiltinSquashField.values();
        int n = builtinSquashFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinSquashField f = builtinSquashFieldArray[n2];
            code = f.toString();
            String label = this.i18nhelper.getMessage(LANG_FIELD_PREFIX + code, null, "translation of " + code, locale);
            fields.put(code, label);
            ++n2;
        }
        List cufs = this.cufService.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.REQUIREMENT_VERSION);
        for (CustomFieldBinding cufB : cufs) {
            CustomField cf = cufB.getCustomField();
            code = cf.getCode();
            String name = cf.getName();
            fields.put(code, name);
        }
        return fields;
    }

    private Map<String, String> makeGitLabFieldList() {
        HashMap<String, String> fields = new HashMap<String, String>();
        GitLabField[] gitLabFieldArray = GitLabField.values();
        int n = gitLabFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            GitLabField field = gitLabFieldArray[n2];
            fields.put(field.rawValue, field.rawValue);
            ++n2;
        }
        return fields;
    }

    private Map<String, List<String>> makeValueMappingsList(Long projectId) {
        LinkedHashMap<String, List<String>> valueMappings = new LinkedHashMap<String, List<String>>();
        GenericProject project = this.genericProjectFinder.findById(projectId.longValue());
        List<String> requirementCriticalities = Arrays.asList("critical", "major", "minor", "undefined");
        List<String> requirementStatuses = Arrays.asList("work_in_progress", "under_review", "approved", "obsolete");
        List<String> requirementCategories = this.fieldMappingService.getAvailableCategoryValues(project);
        valueMappings.put("criticality", requirementCriticalities);
        valueMappings.put("category", requirementCategories);
        valueMappings.put("status", requirementStatuses);
        return valueMappings;
    }

    private BoardsByPerimeterByBugTrackerDto fetchBoardsByPerimeter(List<SynchronisationDto> synchronisations) {
        BoardsByPerimeterByBugTrackerDto dto = new BoardsByPerimeterByBugTrackerDto();
        synchronisations.stream().map(PerimeterAndBugTracker::from).distinct().forEach(perimeterAndBugTracker -> {
            Long bugTrackerId = perimeterAndBugTracker.bugTrackerId;
            String perimeter = perimeterAndBugTracker.perimeter;
            List<GitLabNamedReferenceDto> boards = this.gitLabPerimeterService.getBoards(bugTrackerId, perimeter);
            dto.setBoards(bugTrackerId, perimeter, boards);
        });
        return dto;
    }

    public boolean isCallbackUrlSet() {
        try {
            return this.callbackUrlProvider.getCallbackUrl() != null;
        }
        catch (BadConfiguration badConfiguration) {
            LOGGER.debug("Bad configuration for callback URL", (Throwable)badConfiguration);
            return false;
        }
    }

    private String getCallbackUrl() {
        return Optional.of(this.callbackUrlProvider.getCallbackUrl()).map(URL::toExternalForm).orElse(null);
    }

    private String getWebhookSecretTokenIfShown() {
        if (this.webhookSecretTokenProvider.isSecretTokenShown()) {
            return this.webhookSecretTokenProvider.getSecretToken();
        }
        return null;
    }

    private List<String> getLabelSuffixes() {
        return Arrays.stream(RemoteTestingStatus.values()).map(RemoteTestingStatusLabelHelper::findStatusLabel).toList();
    }

    static class PerimeterAndBugTracker {
        final Long bugTrackerId;
        final String perimeter;

        public PerimeterAndBugTracker(Long bugTrackerId, String perimeter) {
            this.bugTrackerId = bugTrackerId;
            this.perimeter = perimeter;
        }

        public static PerimeterAndBugTracker from(SynchronisationDto dto) {
            return new PerimeterAndBugTracker(dto.getServerId(), dto.getPerimeter());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerimeterAndBugTracker that = (PerimeterAndBugTracker)o;
            return Objects.equal((Object)this.bugTrackerId, (Object)that.bugTrackerId) && Objects.equal((Object)this.perimeter, (Object)that.perimeter);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.bugTrackerId, this.perimeter});
        }
    }
}

