/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.DateConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIterationsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIterationsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetSingleGroupIterationsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.fragment.GetGroupIterations;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.fragment.GetGroupIterationsWithoutAncestors;

public class GitLabIterationConverter {
    public static List<IterationDto> convertProjectIterations(@Nullable GetProjectIterationsQuery.Data projectIterationsData) {
        List nodes = Optional.ofNullable(projectIterationsData).map(GetProjectIterationsQuery.Data::project).map(GetProjectIterationsQuery.Project::iterations).map(GetProjectIterationsQuery.Iterations::nodes).orElse(Collections.emptyList());
        return nodes.stream().map(GitLabIterationConverter::convertOneProjectIteration).collect(Collectors.toList());
    }

    private static IterationDto convertOneProjectIteration(GetProjectIterationsQuery.Node node) {
        return new IterationDto(node.id(), node.title(), GitLabIterationConverter.retrieveDate(node.startDate()), GitLabIterationConverter.retrieveDate(node.dueDate()), node.iterationCadence().title(), node.state());
    }

    public static GroupIterationsFirstPageResult convertFirstPageGroupIterations(@Nullable GetGroupIterationsQuery.Data data) {
        List<IterationDto> iterations = GitLabIterationConverter.convertGroupIterations(data);
        Map<String, Optional<String>> endCursorsByGroupPath = GitLabIterationConverter.extractEndCursorsByGroupPath(data);
        return new GroupIterationsFirstPageResult(iterations, endCursorsByGroupPath);
    }

    private static Map<String, Optional<String>> extractEndCursorsByGroupPath(@Nullable GetGroupIterationsQuery.Data data) {
        HashMap<String, Optional<String>> result = new HashMap<String, Optional<String>>();
        Optional.ofNullable(data).map(GetGroupIterationsQuery.Data::group).ifPresent(group -> {
            GetGroupIterations.Iterations iterations = group.fragments().getGroupIterations().iterations();
            Optional<String> endCursor = Optional.ofNullable(iterations).map(GetGroupIterations.Iterations::pageInfo).map(GetGroupIterations.PageInfo::endCursor);
            result.put(group.fullPath(), endCursor);
        });
        Optional.ofNullable(data).map(GetGroupIterationsQuery.Data::group).map(GetGroupIterationsQuery.Group::descendantGroups).map(GetGroupIterationsQuery.DescendantGroups::nodes).ifPresent(descendantGroupNodes -> descendantGroupNodes.forEach(groupNode -> {
            GetGroupIterationsWithoutAncestors.Iterations iterations = groupNode.fragments().getGroupIterationsWithoutAncestors().iterations();
            Optional<String> endCursor = Optional.ofNullable(iterations).map(GetGroupIterationsWithoutAncestors.Iterations::pageInfo).map(GetGroupIterationsWithoutAncestors.PageInfo::endCursor);
            result.put(groupNode.fullPath(), endCursor);
        }));
        return result;
    }

    private static List<IterationDto> convertGroupIterations(@Nullable GetGroupIterationsQuery.Data groupIterationsData) {
        List nodes = Optional.ofNullable(groupIterationsData).map(GetGroupIterationsQuery.Data::group).map(GetGroupIterationsQuery.Group::fragments).map(GetGroupIterationsQuery.Group.Fragments::getGroupIterations).map(GetGroupIterations::iterations).map(GetGroupIterations.Iterations::nodes).orElse(Collections.emptyList());
        Stream<GetGroupIterationsWithoutAncestors.Node> descendantNodes = Optional.ofNullable(groupIterationsData).map(GetGroupIterationsQuery.Data::group).map(GetGroupIterationsQuery.Group::descendantGroups).map(GetGroupIterationsQuery.DescendantGroups::nodes).map(descendantGroupNodes -> descendantGroupNodes.stream().map(GetGroupIterationsQuery.Node::fragments).map(GetGroupIterationsQuery.Node.Fragments::getGroupIterationsWithoutAncestors).map(GetGroupIterationsWithoutAncestors::iterations).filter(Objects::nonNull).map(GetGroupIterationsWithoutAncestors.Iterations::nodes).filter(Objects::nonNull).flatMap(Collection::stream)).orElse(Stream.builder().build());
        List groupIterations = nodes.stream().map(GitLabIterationConverter::convertOneGroupIteration).collect(Collectors.toList());
        List descendantIterations = descendantNodes.map(GitLabIterationConverter::convertOneGroupIteration).collect(Collectors.toList());
        return Stream.concat(groupIterations.stream(), descendantIterations.stream()).collect(Collectors.toList());
    }

    private static IterationDto convertOneGroupIteration(GetGroupIterations.Node node) {
        return new IterationDto(node.id(), node.title(), GitLabIterationConverter.retrieveDate(node.startDate()), GitLabIterationConverter.retrieveDate(node.dueDate()), node.iterationCadence().title(), node.state());
    }

    private static IterationDto convertOneGroupIteration(GetGroupIterationsWithoutAncestors.Node node) {
        return new IterationDto(node.id(), node.title(), GitLabIterationConverter.retrieveDate(node.startDate()), GitLabIterationConverter.retrieveDate(node.dueDate()), node.iterationCadence().title(), node.state());
    }

    public static List<IterationDto> convertSingleGroupIterations(@Nullable GetSingleGroupIterationsQuery.Data data) {
        return Optional.ofNullable(data).map(GetSingleGroupIterationsQuery.Data::group).map(GetSingleGroupIterationsQuery.Group::iterations).map(GetSingleGroupIterationsQuery.Iterations::nodes).orElse(Collections.emptyList()).stream().map(GitLabIterationConverter::convertOneSingleGroupIteration).collect(Collectors.toList());
    }

    private static IterationDto convertOneSingleGroupIteration(GetSingleGroupIterationsQuery.Node node) {
        return new IterationDto(node.id(), node.title(), GitLabIterationConverter.retrieveDate(node.startDate()), GitLabIterationConverter.retrieveDate(node.dueDate()), node.iterationCadence().title(), node.state());
    }

    private GitLabIterationConverter() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }

    private static Date retrieveDate(Object date) {
        return date != null ? DateConverter.parseDate(date.toString()) : null;
    }

    public static class GroupIterationsFirstPageResult {
        public final List<IterationDto> firstPageIterations;
        public final Map<String, Optional<String>> endCursorsByGroupPath;

        public GroupIterationsFirstPageResult(List<IterationDto> firstPageIterations, Map<String, Optional<String>> endCursorsByGroupPath) {
            this.firstPageIterations = firstPageIterations;
            this.endCursorsByGroupPath = endCursorsByGroupPath;
        }
    }
}

