/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.controller.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.squashtest.tm.core.foundation.lang.Assert;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.Mappings;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSelectType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SyncedRequirementHierarchy;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValueId;

public class CreateSynchronisationModel {
    private String name;
    private String synchronisationPath;
    private Long serverId;
    private String perimeter;
    private List<SynchronisationFilterValue> filterValues = new ArrayList<SynchronisationFilterValue>();
    private List<SynchronisationFilterValue> sprintFilterValues = new ArrayList<SynchronisationFilterValue>();
    private String remoteSelectType;
    private String boardId;
    private String hierarchy;
    private boolean sprintSynchronisationEnable;
    private String sprintSynchronisationPath;
    private String sprintSelectValue;
    private String sprintRemoteSelectType;
    private boolean checkMaxItems;
    private boolean displayState;
    private boolean statusLabelEnabled;
    private String statusLabelPrefix;
    private Mappings mappings;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSynchronisationPath() {
        return this.synchronisationPath;
    }

    public void setSynchronisationPath(String synchronisationPath) {
        this.synchronisationPath = synchronisationPath;
    }

    public Long getServerId() {
        return this.serverId;
    }

    public void setServerId(Long serverId) {
        this.serverId = serverId;
    }

    public String getPerimeter() {
        return this.perimeter;
    }

    public void setPerimeter(String perimeter) {
        this.perimeter = perimeter;
    }

    public List<SynchronisationFilterValue> getFilterValues() {
        return this.filterValues;
    }

    public void setFilterValues(List<SynchronisationFilterValue> filterValues) {
        this.filterValues = filterValues;
    }

    public List<SynchronisationFilterValue> getSprintFilterValues() {
        return this.sprintFilterValues;
    }

    public void setSprintFilterValues(List<SynchronisationFilterValue> sprintFilterValues) {
        this.sprintFilterValues = sprintFilterValues;
    }

    public String getRemoteSelectType() {
        return this.remoteSelectType;
    }

    public void setRemoteSelectType(String remoteSelectType) {
        this.remoteSelectType = remoteSelectType;
    }

    public String getBoardId() {
        return this.boardId;
    }

    public void setBoardId(String boardId) {
        this.boardId = boardId;
    }

    public String getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public boolean isSprintSynchronisationEnable() {
        return this.sprintSynchronisationEnable;
    }

    public void setSprintSynchronisationEnable(boolean sprintSynchronisationEnable) {
        this.sprintSynchronisationEnable = sprintSynchronisationEnable;
    }

    public String getSprintSynchronisationPath() {
        return this.sprintSynchronisationPath;
    }

    public void setSprintSynchronisationPath(String sprintSynchronisationPath) {
        this.sprintSynchronisationPath = sprintSynchronisationPath;
    }

    public String getSprintSelectValue() {
        return this.sprintSelectValue;
    }

    public void setSprintSelectValue(String sprintSelectValue) {
        this.sprintSelectValue = sprintSelectValue;
    }

    public String getSprintRemoteSelectType() {
        return this.sprintRemoteSelectType;
    }

    public void setSprintRemoteSelectType(String sprintRemoteSelectType) {
        this.sprintRemoteSelectType = sprintRemoteSelectType;
    }

    public boolean isCheckMaxItems() {
        return this.checkMaxItems;
    }

    public void setCheckMaxItems(boolean checkMaxItems) {
        this.checkMaxItems = checkMaxItems;
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public boolean isDisplayState() {
        return this.displayState;
    }

    public void setDisplayState(boolean displayState) {
        this.displayState = displayState;
    }

    public void cleanPaths() {
        if (Objects.nonNull(this.getSynchronisationPath())) {
            this.setSynchronisationPath(PathUtils.removeAllUnnecessarySpaces((String)this.getSynchronisationPath()));
        }
        if (Objects.nonNull(this.getSprintSynchronisationPath())) {
            this.setSprintSynchronisationPath(PathUtils.removeAllUnnecessarySpaces((String)this.getSprintSynchronisationPath()));
        }
    }

    public void validate() {
        Assert.propertyNotBlank((String)this.name, (String)"name cannot be empty");
        Assert.propertyNotBlank((String)this.synchronisationPath, (String)"synchronisationPath cannot be empty");
        Assert.parameterNotNull((Object)this.serverId, (String)"serverId");
        Assert.propertyNotBlank((String)this.perimeter, (String)"perimeter cannot be empty");
        Assert.propertyNotBlank((String)this.remoteSelectType, (String)"remoteSelectType cannot be empty");
        Assert.propertyNotBlank((String)this.hierarchy, (String)"hierarchy cannot be empty");
        if (this.isSprintSynchronisationEnable()) {
            Assert.propertyNotBlank((String)this.sprintSynchronisationPath, (String)"sprintSynchronisationPath cannot be empty");
            Assert.propertyNotBlank((String)this.sprintRemoteSelectType, (String)"sprintRemoteSelectType cannot be empty");
            try {
                GitLabRemoteSelectType.valueOf(this.sprintRemoteSelectType);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unknown sprint remote select type '%s'".formatted(this.sprintRemoteSelectType), ex);
            }
            for (SynchronisationFilterValue value : this.sprintFilterValues) {
                try {
                    SynchronisationFilterValueId.valueOf(value.getId());
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("Unknown filter value ID '%s'".formatted(value.getId()), ex);
                }
            }
        }
        try {
            GitLabRemoteSelectType.valueOf(this.remoteSelectType);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unknown remote select type '%s'".formatted(this.remoteSelectType), ex);
        }
        try {
            SyncedRequirementHierarchy.valueOf(this.hierarchy);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unknown synced requirement hierarchy '%s'".formatted(this.hierarchy), ex);
        }
        for (SynchronisationFilterValue value : this.filterValues) {
            try {
                SynchronisationFilterValueId.valueOf(value.getId());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unknown filter value ID '%s'".formatted(value.getId()), ex);
            }
        }
    }

    public void setStatusLabelEnabled(boolean statusLabelEnabled) {
        this.statusLabelEnabled = statusLabelEnabled;
    }

    public boolean isStatusLabelEnabled() {
        return this.statusLabelEnabled;
    }

    public String getStatusLabelPrefix() {
        return this.statusLabelPrefix;
    }

    public void setStatusLabelPrefix(String statusLabelPrefix) {
        this.statusLabelPrefix = statusLabelPrefix;
    }
}

