/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.controller;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.ConfigurationPageDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabPerimeterInfoDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.SingleValueRequestBodyDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.SynchronisationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.CreateSynchronisationModel;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.FieldMapping;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SprintToCreate;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.UserConfiguration;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationDisplayService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabPerimeterService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronisationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.UserConfigurationService;

@RestController(value="squash.tm.plugin.xsquash4gitlab.configurationController")
@RequestMapping(value={"backend/plugin/xsquash4gitlab/configuration"})
public class ConfigurationController {
    public static final String IS_ENABLED = "isEnabled";
    private final ConfigurationService configurationService;
    private final SynchronisationService synchronisationService;
    private final ConfigurationDisplayService configurationDisplayService;
    private final GitLabPerimeterService gitLabPerimeterService;
    private final UserConfigurationService userConfigurationService;

    public ConfigurationController(ConfigurationService configurationService, SynchronisationService synchronisationService, ConfigurationDisplayService configurationDisplayService, GitLabPerimeterService gitLabPerimeterService, UserConfigurationService userConfigurationService) {
        this.configurationService = configurationService;
        this.synchronisationService = synchronisationService;
        this.configurationDisplayService = configurationDisplayService;
        this.gitLabPerimeterService = gitLabPerimeterService;
        this.userConfigurationService = userConfigurationService;
    }

    @GetMapping(value={"/project/{projectId}"})
    ConfigurationPageDto getConfigurationPage(@PathVariable(value="projectId") long projectId) {
        return this.configurationDisplayService.getConfigurationPage(projectId);
    }

    @PostMapping(value={"/project/{projectId}/simulate-new-sync"})
    public List<GitLabIssue> simulateNewSync(@PathVariable(value="projectId") long projectId, @RequestBody CreateSynchronisationModel model) {
        return this.synchronisationService.simulateNewSynchronisation(projectId, model);
    }

    @PostMapping(value={"/project/{projectId}/simulate-new-sprint-sync"})
    public List<SprintToCreate> simulateNewSprintSync(@PathVariable(value="projectId") long projectId, @RequestBody CreateSynchronisationModel model) {
        return this.synchronisationService.simulateNewSprintSynchronisation(projectId, model);
    }

    @PostMapping(value={"/project/{projectId}/sync"})
    public SynchronisationDto createNewSynchronisation(@PathVariable(value="projectId") long projectId, @RequestBody CreateSynchronisationModel model) {
        model.validate();
        return this.configurationService.createNewSynchronisation(projectId, model);
    }

    @PostMapping(value={"/sync/{syncId}/create-sprint-sync"})
    public SynchronisationDto createNewSprintSynchronisation(@PathVariable(value="syncId") long syncId, @RequestBody CreateSynchronisationModel model) {
        model.validate();
        return this.configurationService.createNewSprintSynchronisation(syncId, model);
    }

    @PostMapping(value={"/sync/{syncId}/delete-sprint-sync"})
    public SynchronisationDto deleteSprintSynchronisation(@PathVariable(value="syncId") long syncId) {
        return this.configurationService.deleteSprintSynchronisation(syncId);
    }

    @PostMapping(value={"/sync/{syncId}/update-sprint-sync"})
    public SynchronisationDto updateSynchronisation(@PathVariable(value="syncId") long syncId, @RequestBody CreateSynchronisationModel model) {
        model.validate();
        return this.configurationService.updateSprintSynchronisation(syncId, model);
    }

    @PostMapping(value={"/sync/{syncId}/update-reporting"})
    public SynchronisationDto updateSynchronisationReporting(@PathVariable(value="syncId") long syncId, @RequestBody UpdateReportingModel model) {
        return this.configurationService.updateSynchronisationReporting(syncId, model.statusLabelEnabled(), model.statusLabelPrefix());
    }

    @PostMapping(value={"/project/{projectId}/validate-form-step-one"})
    public void validateFormStepOne(@PathVariable(value="projectId") long projectId, @RequestBody CreateSynchronisationModel model) {
        this.configurationService.validateFormStepOne(projectId, model);
    }

    @PostMapping(value={"/project/{projectId}/sync/{syncId}/toggle-sync"})
    public void toggleSync(@PathVariable(value="syncId") Long syncId, @RequestBody Map<String, Boolean> body) {
        this.configurationService.toggleSync(syncId, body.get(IS_ENABLED));
    }

    @PostMapping(value={"/sync/filters/info"})
    public GitLabPerimeterInfoDto getPerimeterInfo(@RequestBody PerimeterInfoRequestBody requestBody) {
        return this.gitLabPerimeterService.getPerimeterReferentialData(requestBody.bugTrackerId, requestBody.perimeter);
    }

    @DeleteMapping(value={"/project/{projectId}/sync/{syncIds}"})
    public void deleteSynchronisations(@PathVariable(value="projectId") long projectId, @PathVariable(value="syncIds") List<Long> syncIds) {
        this.configurationService.deleteRemoteSynchronisations(projectId, syncIds);
    }

    @PostMapping(value={"/sync/{syncIds}/force-sync"})
    public void forceFullSynchronisation(@PathVariable(value="syncIds") List<Long> syncIds) {
        for (Long syncId : syncIds) {
            this.configurationService.commandFullSynchronisation(syncId);
        }
    }

    @PostMapping(value={"/sync/{syncId}/update-board"})
    public void updateBoard(@PathVariable(value="syncId") long syncId, @RequestBody Map<String, String> requestBody) {
        this.configurationService.updateBoard(syncId, requestBody.get("boardId"));
    }

    @PostMapping(value={"/sync/{syncId}/name"})
    public void updateSynchronisationName(@PathVariable(value="syncId") long syncId, @RequestBody Map<String, String> requestBody) {
        String newName = requestBody.get("name");
        this.configurationService.updateName(syncId, newName);
    }

    @PostMapping(value={"/sync/{syncId}/filters"})
    public void updateFilterValues(@PathVariable(value="syncId") long syncId, @RequestBody Map<String, List<SynchronisationFilterValue>> requestBody) throws IOException {
        List<SynchronisationFilterValue> filterValues = requestBody.get("filterValues");
        this.configurationService.updateFilterValues(syncId, filterValues);
    }

    @PostMapping(value={"/project/{projectId}/mappings"})
    public Map<String, String> addFieldMapping(@PathVariable(value="projectId") Long projectId, @RequestBody FieldMapping newMapping) {
        this.configurationService.addFieldMapping(projectId, newMapping);
        return Collections.singletonMap("gitLabValue", newMapping.getGitLabField());
    }

    @PostMapping(value={"/project/{projectId}/mappings/{id}/squashField"})
    public Map<String, String> changeMappingSquashField(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") String mappingId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        FieldMapping mapping = this.configurationService.updateFieldMappingSquashField(projectId, mappingId, requestBody.value());
        return Collections.singletonMap("gitLabValue", mapping.getGitLabField());
    }

    @PostMapping(value={"/project/{projectId}/mappings/{id}/gitLabField"})
    public void changeMappingGitLabField(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") String mappingId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.configurationService.updateFieldMappingGitLabField(projectId, mappingId, requestBody.value());
    }

    @GetMapping(value={"/project/{projectId}/value-mappings"})
    public Map<String, String> retrieveValueMappings(@PathVariable(value="projectId") Long projectId) {
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        return Collections.singletonMap("mappings", userConfiguration.getYamlFieldValueMapping());
    }

    @PostMapping(value={"/project/{projectId}/value-mappings"})
    public void changeValueMappings(@PathVariable(value="projectId") Long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.configurationService.updateValueMappings(projectId, requestBody.value());
    }

    @DeleteMapping(value={"/project/{projectId}/mappings/{ids}"})
    public void removeFieldMappings(@PathVariable(value="projectId") Long projectId, @PathVariable(value="ids") List<String> mappingIds) {
        this.configurationService.removeFieldMappingsByIds(projectId, mappingIds);
    }

    @PostMapping(value={"/project/{projectId}/test-reporting/enabled"})
    public void setTestReportingEnabled(@PathVariable(value="projectId") Long projectId, @RequestBody Map<String, Boolean> body) {
        this.configurationService.setTestReportingEnabled(projectId, body.get(IS_ENABLED));
    }

    @PostMapping(value={"/project/{projectId}/test-reporting/status-label-enabled"})
    public void setStatusLabelEnabled(@PathVariable(value="projectId") Long projectId, @RequestBody Map<String, Boolean> body) {
        this.configurationService.setStatusLabelEnabled(projectId, body.get(IS_ENABLED));
    }

    @PostMapping(value={"/project/{projectId}/test-reporting/default-label-prefix"})
    public void setTestReportingDefaultLabelPrefix(@PathVariable(value="projectId") Long projectId, @RequestBody Map<String, String> body) {
        this.configurationService.setTestReportingDefaultLabelPrefix(projectId, body.get("defaultLabelPrefix"));
    }

    private static final class PerimeterInfoRequestBody {
        private String perimeter;
        private Long bugTrackerId;

        private PerimeterInfoRequestBody() {
        }

        public void setPerimeter(String perimeter) {
            this.perimeter = perimeter;
        }

        public void setBugTrackerId(Long bugTrackerId) {
            this.bugTrackerId = bugTrackerId;
        }
    }

    public record UpdateReportingModel(boolean statusLabelEnabled, String statusLabelPrefix) {
    }
}

