/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import xsquash4gitlab.com.apollographql.apollo.ApolloMutationCall;
import xsquash4gitlab.com.apollographql.apollo.ApolloPrefetch;
import xsquash4gitlab.com.apollographql.apollo.ApolloQueryCall;
import xsquash4gitlab.com.apollographql.apollo.ApolloSubscriptionCall;
import xsquash4gitlab.com.apollographql.apollo.IdleResourceCallback;
import xsquash4gitlab.com.apollographql.apollo.Logger;
import xsquash4gitlab.com.apollographql.apollo.api.CustomTypeAdapter;
import xsquash4gitlab.com.apollographql.apollo.api.Mutation;
import xsquash4gitlab.com.apollographql.apollo.api.Operation;
import xsquash4gitlab.com.apollographql.apollo.api.Query;
import xsquash4gitlab.com.apollographql.apollo.api.ScalarType;
import xsquash4gitlab.com.apollographql.apollo.api.ScalarTypeAdapters;
import xsquash4gitlab.com.apollographql.apollo.api.Subscription;
import xsquash4gitlab.com.apollographql.apollo.api.cache.http.HttpCache;
import xsquash4gitlab.com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import xsquash4gitlab.com.apollographql.apollo.api.internal.ApolloLogger;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Optional;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Utils;
import xsquash4gitlab.com.apollographql.apollo.cache.CacheHeaders;
import xsquash4gitlab.com.apollographql.apollo.cache.normalized.ApolloStore;
import xsquash4gitlab.com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import xsquash4gitlab.com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import xsquash4gitlab.com.apollographql.apollo.cache.normalized.NormalizedCache;
import xsquash4gitlab.com.apollographql.apollo.cache.normalized.NormalizedCacheFactory;
import xsquash4gitlab.com.apollographql.apollo.cache.normalized.RecordFieldJsonAdapter;
import xsquash4gitlab.com.apollographql.apollo.cache.normalized.internal.ResponseNormalizer;
import xsquash4gitlab.com.apollographql.apollo.fetcher.ApolloResponseFetchers;
import xsquash4gitlab.com.apollographql.apollo.fetcher.ResponseFetcher;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptor;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptorFactory;
import xsquash4gitlab.com.apollographql.apollo.internal.ApolloCallTracker;
import xsquash4gitlab.com.apollographql.apollo.internal.RealApolloCall;
import xsquash4gitlab.com.apollographql.apollo.internal.RealApolloPrefetch;
import xsquash4gitlab.com.apollographql.apollo.internal.RealApolloStore;
import xsquash4gitlab.com.apollographql.apollo.internal.RealApolloSubscriptionCall;
import xsquash4gitlab.com.apollographql.apollo.internal.batch.BatchConfig;
import xsquash4gitlab.com.apollographql.apollo.internal.batch.BatchHttpCallFactoryImpl;
import xsquash4gitlab.com.apollographql.apollo.internal.batch.BatchPoller;
import xsquash4gitlab.com.apollographql.apollo.internal.batch.PeriodicJobSchedulerImpl;
import xsquash4gitlab.com.apollographql.apollo.internal.subscription.NoOpSubscriptionManager;
import xsquash4gitlab.com.apollographql.apollo.internal.subscription.RealSubscriptionManager;
import xsquash4gitlab.com.apollographql.apollo.internal.subscription.SubscriptionManager;
import xsquash4gitlab.com.apollographql.apollo.subscription.OnSubscriptionManagerStateChangeListener;
import xsquash4gitlab.com.apollographql.apollo.subscription.SubscriptionConnectionParams;
import xsquash4gitlab.com.apollographql.apollo.subscription.SubscriptionConnectionParamsProvider;
import xsquash4gitlab.com.apollographql.apollo.subscription.SubscriptionManagerState;
import xsquash4gitlab.com.apollographql.apollo.subscription.SubscriptionTransport;
import xsquash4gitlab.kotlin.jvm.functions.Function0;
import xsquash4gitlab.okhttp3.Call;
import xsquash4gitlab.okhttp3.HttpUrl;
import xsquash4gitlab.okhttp3.Interceptor;
import xsquash4gitlab.okhttp3.OkHttpClient;
import xsquash4gitlab.okhttp3.Response;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

public final class ApolloClient
implements ApolloQueryCall.Factory,
ApolloMutationCall.Factory,
ApolloPrefetch.Factory,
ApolloSubscriptionCall.Factory {
    private final HttpUrl serverUrl;
    private final Call.Factory httpCallFactory;
    private final HttpCache httpCache;
    private final ApolloStore apolloStore;
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final Executor dispatcher;
    private final HttpCachePolicy.Policy defaultHttpCachePolicy;
    private final ResponseFetcher defaultResponseFetcher;
    private final CacheHeaders defaultCacheHeaders;
    private final ApolloLogger logger;
    private final ApolloCallTracker tracker = new ApolloCallTracker();
    private final List<ApolloInterceptor> applicationInterceptors;
    private final List<ApolloInterceptorFactory> applicationInterceptorFactories;
    private final ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory;
    private final boolean enableAutoPersistedQueries;
    private final SubscriptionManager subscriptionManager;
    private final boolean useHttpGetMethodForQueries;
    private final boolean useHttpGetMethodForPersistedQueries;
    private final boolean writeToNormalizedCacheAsynchronously;
    private final BatchPoller batchPoller;
    private final BatchConfig batchConfig;

    public static Builder builder() {
        return new Builder();
    }

    ApolloClient(HttpUrl serverUrl, Call.Factory httpCallFactory, HttpCache httpCache, ApolloStore apolloStore, ScalarTypeAdapters scalarTypeAdapters, Executor dispatcher, HttpCachePolicy.Policy defaultHttpCachePolicy, ResponseFetcher defaultResponseFetcher, CacheHeaders defaultCacheHeaders, ApolloLogger logger, List<ApolloInterceptor> applicationInterceptors, List<ApolloInterceptorFactory> applicationInterceptorFactories, ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory, boolean enableAutoPersistedQueries, SubscriptionManager subscriptionManager, boolean useHttpGetMethodForQueries, boolean useHttpGetMethodForPersistedQueries, boolean writeToNormalizedCacheAsynchronously, BatchConfig batchConfig) {
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.httpCache = httpCache;
        this.apolloStore = apolloStore;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.dispatcher = dispatcher;
        this.defaultHttpCachePolicy = defaultHttpCachePolicy;
        this.defaultResponseFetcher = defaultResponseFetcher;
        this.defaultCacheHeaders = defaultCacheHeaders;
        this.logger = logger;
        if (!applicationInterceptorFactories.isEmpty() && !applicationInterceptors.isEmpty()) {
            throw new IllegalArgumentException("You can either use applicationInterceptors or applicationInterceptorFactories but not both at the same time.");
        }
        this.applicationInterceptors = applicationInterceptors;
        this.applicationInterceptorFactories = applicationInterceptorFactories;
        this.autoPersistedOperationsInterceptorFactory = autoPersistedOperationsInterceptorFactory;
        this.enableAutoPersistedQueries = enableAutoPersistedQueries;
        this.subscriptionManager = subscriptionManager;
        this.useHttpGetMethodForQueries = useHttpGetMethodForQueries;
        this.useHttpGetMethodForPersistedQueries = useHttpGetMethodForPersistedQueries;
        this.writeToNormalizedCacheAsynchronously = writeToNormalizedCacheAsynchronously;
        this.batchConfig = batchConfig;
        this.batchPoller = batchConfig.getBatchingEnabled() ? new BatchPoller(batchConfig, dispatcher, new BatchHttpCallFactoryImpl(serverUrl, httpCallFactory, scalarTypeAdapters), logger, new PeriodicJobSchedulerImpl()) : null;
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloMutationCall<T> mutate(@NotNull Mutation<D, T, V> mutation) {
        return this.newCall(mutation).responseFetcher(ApolloResponseFetchers.NETWORK_ONLY);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloMutationCall<T> mutate(@NotNull Mutation<D, T, V> mutation, @NotNull D withOptimisticUpdates) {
        Utils.checkNotNull(withOptimisticUpdates, "withOptimisticUpdate == null");
        return ((RealApolloCall.Builder)((RealApolloCall.Builder)this.newCall(mutation).toBuilder()).responseFetcher(ApolloResponseFetchers.NETWORK_ONLY)).optimisticUpdates(Optional.fromNullable(withOptimisticUpdates)).build();
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloQueryCall<T> query(@NotNull Query<D, T, V> query) {
        return this.newCall(query);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloPrefetch prefetch(@NotNull Operation<D, T, V> operation) {
        return new RealApolloPrefetch(operation, this.serverUrl, this.httpCallFactory, this.scalarTypeAdapters, this.dispatcher, this.logger, this.tracker);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloSubscriptionCall<T> subscribe(@NotNull Subscription<D, T, V> subscription) {
        return new RealApolloSubscriptionCall<T>(subscription, this.subscriptionManager, this.apolloStore, ApolloSubscriptionCall.CachePolicy.NO_CACHE, this.dispatcher, this.logger);
    }

    public void addOnSubscriptionManagerStateChangeListener(@NotNull OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        this.subscriptionManager.addOnStateChangeListener(Utils.checkNotNull(onStateChangeListener, "onStateChangeListener is null"));
    }

    public void removeOnSubscriptionManagerStateChangeListener(@NotNull OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        this.subscriptionManager.removeOnStateChangeListener(Utils.checkNotNull(onStateChangeListener, "onStateChangeListener is null"));
    }

    public SubscriptionManagerState getSubscriptionManagerState() {
        return this.subscriptionManager.getState();
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void enableSubscriptions() {
        this.subscriptionManager.start();
    }

    public void disableSubscriptions() {
        this.subscriptionManager.stop();
    }

    public void startBatchPoller() {
        if (this.batchPoller != null) {
            this.batchPoller.start();
        }
    }

    public void stopBatchPoller() {
        if (this.batchPoller != null) {
            this.batchPoller.stop();
        }
    }

    @Deprecated
    public CacheHeaders defaultCacheHeaders() {
        return this.defaultCacheHeaders;
    }

    public CacheHeaders getDefaultCacheHeaders() {
        return this.defaultCacheHeaders;
    }

    public void clearHttpCache() {
        if (this.httpCache != null) {
            this.httpCache.clear();
        }
    }

    public void clearNormalizedCache(@NotNull ApolloStoreOperation.Callback<Boolean> callback) {
        Utils.checkNotNull(callback, "callback == null");
        this.apolloStore.clearAll().enqueue(callback);
    }

    public boolean clearNormalizedCache() {
        return this.apolloStore.clearAll().execute();
    }

    @Deprecated
    public ApolloStore apolloStore() {
        return this.apolloStore;
    }

    public ApolloStore getApolloStore() {
        return this.apolloStore;
    }

    public HttpUrl getServerUrl() {
        return this.serverUrl;
    }

    public HttpCache getHttpCache() {
        return this.httpCache;
    }

    public ScalarTypeAdapters getScalarTypeAdapters() {
        return this.scalarTypeAdapters;
    }

    public List<ApolloInterceptor> getApplicationInterceptors() {
        return Collections.unmodifiableList(this.applicationInterceptors);
    }

    public List<ApolloInterceptorFactory> getApplicationInterceptorFactories() {
        return Collections.unmodifiableList(this.applicationInterceptorFactories);
    }

    public ApolloInterceptorFactory getAutoPersistedOperationsInterceptorFactory() {
        return this.autoPersistedOperationsInterceptorFactory;
    }

    public void idleCallback(IdleResourceCallback idleResourceCallback) {
        this.tracker.setIdleResourceCallback(idleResourceCallback);
    }

    public int activeCallsCount() {
        return this.tracker.activeCallsCount();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    Response cachedHttpResponse(String cacheKey) throws IOException {
        if (this.httpCache != null) {
            return this.httpCache.read(cacheKey);
        }
        return null;
    }

    private <D extends Operation.Data, T, V extends Operation.Variables> RealApolloCall<T> newCall(@NotNull Operation<D, T, V> operation) {
        return ((RealApolloCall.Builder)((RealApolloCall.Builder)((RealApolloCall.Builder)((RealApolloCall.Builder)((RealApolloCall.Builder)RealApolloCall.builder().operation(operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.defaultHttpCachePolicy)).scalarTypeAdapters(this.scalarTypeAdapters).apolloStore(this.apolloStore).responseFetcher(this.defaultResponseFetcher)).cacheHeaders(this.defaultCacheHeaders)).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).applicationInterceptorFactories(this.applicationInterceptorFactories).autoPersistedOperationsInterceptorFactory(this.autoPersistedOperationsInterceptorFactory).tracker(this.tracker).refetchQueries(Collections.emptyList())).refetchQueryNames(Collections.emptyList())).enableAutoPersistedQueries(this.enableAutoPersistedQueries).useHttpGetMethodForQueries(this.useHttpGetMethodForQueries).useHttpGetMethodForPersistedQueries(this.useHttpGetMethodForPersistedQueries).writeToNormalizedCacheAsynchronously(this.writeToNormalizedCacheAsynchronously).batchPoller(this.batchPoller).build();
    }

    public static class Builder {
        Call.Factory callFactory;
        HttpUrl serverUrl;
        HttpCache httpCache;
        ApolloStore apolloStore = ApolloStore.NO_APOLLO_STORE;
        Optional<NormalizedCacheFactory> cacheFactory = Optional.absent();
        Optional<CacheKeyResolver> cacheKeyResolver = Optional.absent();
        HttpCachePolicy.Policy defaultHttpCachePolicy = HttpCachePolicy.NETWORK_ONLY;
        ResponseFetcher defaultResponseFetcher = ApolloResponseFetchers.CACHE_FIRST;
        CacheHeaders defaultCacheHeaders = CacheHeaders.NONE;
        final Map<ScalarType, CustomTypeAdapter<?>> customTypeAdapters = new LinkedHashMap();
        Executor dispatcher;
        @Nullable
        Logger logger = null;
        final List<ApolloInterceptor> applicationInterceptors = new ArrayList<ApolloInterceptor>();
        final List<ApolloInterceptorFactory> applicationInterceptorFactories = new ArrayList<ApolloInterceptorFactory>();
        @Nullable
        ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory = null;
        boolean enableAutoPersistedQueries;
        SubscriptionManager subscriptionManager = new NoOpSubscriptionManager();
        boolean enableAutoPersistedSubscriptions;
        Optional<SubscriptionTransport.Factory> subscriptionTransportFactory = Optional.absent();
        SubscriptionConnectionParamsProvider subscriptionConnectionParams = new SubscriptionConnectionParamsProvider.Const(new SubscriptionConnectionParams());
        long subscriptionHeartbeatTimeout = -1L;
        boolean useHttpGetMethodForQueries;
        boolean useHttpGetMethodForPersistedQueries;
        boolean writeToNormalizedCacheAsynchronously;
        boolean enableQueryBatching;
        BatchConfig batchConfig;

        Builder() {
        }

        private Builder(@NotNull ApolloClient apolloClient) {
            this.callFactory = apolloClient.httpCallFactory;
            this.serverUrl = apolloClient.serverUrl;
            this.httpCache = apolloClient.httpCache;
            this.apolloStore = apolloClient.apolloStore;
            this.defaultHttpCachePolicy = apolloClient.defaultHttpCachePolicy;
            this.defaultResponseFetcher = apolloClient.defaultResponseFetcher;
            this.defaultCacheHeaders = apolloClient.defaultCacheHeaders;
            this.customTypeAdapters.putAll(apolloClient.scalarTypeAdapters.getCustomAdapters());
            this.dispatcher = apolloClient.dispatcher;
            this.logger = apolloClient.logger.getLogger();
            this.applicationInterceptors.addAll(apolloClient.applicationInterceptors);
            this.applicationInterceptorFactories.addAll(apolloClient.applicationInterceptorFactories);
            this.autoPersistedOperationsInterceptorFactory = apolloClient.getAutoPersistedOperationsInterceptorFactory();
            this.enableAutoPersistedQueries = apolloClient.enableAutoPersistedQueries;
            this.subscriptionManager = apolloClient.subscriptionManager;
            this.useHttpGetMethodForQueries = apolloClient.useHttpGetMethodForQueries;
            this.useHttpGetMethodForPersistedQueries = apolloClient.useHttpGetMethodForPersistedQueries;
            this.writeToNormalizedCacheAsynchronously = apolloClient.writeToNormalizedCacheAsynchronously;
            this.batchConfig = apolloClient.batchConfig;
        }

        public Builder okHttpClient(@NotNull OkHttpClient okHttpClient) {
            return this.callFactory(Utils.checkNotNull(okHttpClient, "okHttpClient is null"));
        }

        public Builder callFactory(@NotNull Call.Factory factory) {
            this.callFactory = Utils.checkNotNull(factory, "factory == null");
            return this;
        }

        public Builder serverUrl(@NotNull HttpUrl serverUrl) {
            this.serverUrl = Utils.checkNotNull(serverUrl, "serverUrl is null");
            return this;
        }

        public Builder serverUrl(@NotNull String serverUrl) {
            this.serverUrl = HttpUrl.parse(Utils.checkNotNull(serverUrl, "serverUrl == null"));
            return this;
        }

        public Builder httpCache(@NotNull HttpCache httpCache) {
            this.httpCache = Utils.checkNotNull(httpCache, "httpCache == null");
            return this;
        }

        public Builder normalizedCache(@NotNull NormalizedCacheFactory normalizedCacheFactory) {
            return this.normalizedCache(normalizedCacheFactory, CacheKeyResolver.DEFAULT);
        }

        public Builder normalizedCache(@NotNull NormalizedCacheFactory normalizedCacheFactory, @NotNull CacheKeyResolver keyResolver) {
            return this.normalizedCache(normalizedCacheFactory, keyResolver, false);
        }

        public Builder normalizedCache(@NotNull NormalizedCacheFactory normalizedCacheFactory, @NotNull CacheKeyResolver keyResolver, boolean writeToCacheAsynchronously) {
            this.cacheFactory = Optional.fromNullable(Utils.checkNotNull(normalizedCacheFactory, "normalizedCacheFactory == null"));
            this.cacheKeyResolver = Optional.fromNullable(Utils.checkNotNull(keyResolver, "cacheKeyResolver == null"));
            this.writeToNormalizedCacheAsynchronously = writeToCacheAsynchronously;
            return this;
        }

        public <T> Builder addCustomTypeAdapter(@NotNull ScalarType scalarType, @NotNull CustomTypeAdapter<T> customTypeAdapter) {
            this.customTypeAdapters.put(scalarType, customTypeAdapter);
            return this;
        }

        public Builder dispatcher(@NotNull Executor dispatcher) {
            this.dispatcher = Utils.checkNotNull(dispatcher, "dispatcher == null");
            return this;
        }

        public Builder defaultHttpCachePolicy(@NotNull HttpCachePolicy.Policy cachePolicy) {
            this.defaultHttpCachePolicy = Utils.checkNotNull(cachePolicy, "cachePolicy == null");
            return this;
        }

        public Builder defaultCacheHeaders(@NotNull CacheHeaders cacheHeaders) {
            this.defaultCacheHeaders = Utils.checkNotNull(cacheHeaders, "cacheHeaders == null");
            return this;
        }

        public Builder defaultResponseFetcher(@NotNull ResponseFetcher defaultResponseFetcher) {
            this.defaultResponseFetcher = Utils.checkNotNull(defaultResponseFetcher, "defaultResponseFetcher == null");
            return this;
        }

        public Builder logger(@Nullable Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder addApplicationInterceptor(@NotNull ApolloInterceptor interceptor) {
            this.applicationInterceptors.add(interceptor);
            return this;
        }

        public Builder addApplicationInterceptorFactory(@NotNull ApolloInterceptorFactory interceptorFactory) {
            this.applicationInterceptorFactories.add(interceptorFactory);
            return this;
        }

        public Builder setAutoPersistedOperationsInterceptorFactory(@Nullable ApolloInterceptorFactory interceptorFactory) {
            this.autoPersistedOperationsInterceptorFactory = interceptorFactory;
            return this;
        }

        public Builder enableAutoPersistedQueries(boolean enableAutoPersistedQueries) {
            this.enableAutoPersistedQueries = enableAutoPersistedQueries;
            return this;
        }

        public Builder subscriptionTransportFactory(@NotNull SubscriptionTransport.Factory subscriptionTransportFactory) {
            this.subscriptionTransportFactory = Optional.of(Utils.checkNotNull(subscriptionTransportFactory, "subscriptionTransportFactory is null"));
            return this;
        }

        public Builder subscriptionConnectionParams(@NotNull SubscriptionConnectionParams connectionParams) {
            this.subscriptionConnectionParams = new SubscriptionConnectionParamsProvider.Const(Utils.checkNotNull(connectionParams, "connectionParams is null"));
            return this;
        }

        public Builder subscriptionConnectionParams(@NotNull SubscriptionConnectionParamsProvider provider) {
            this.subscriptionConnectionParams = Utils.checkNotNull(provider, "provider is null");
            return this;
        }

        public Builder subscriptionHeartbeatTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            Utils.checkNotNull(timeUnit, "timeUnit is null");
            this.subscriptionHeartbeatTimeout = Math.max(timeUnit.toMillis(timeout), TimeUnit.SECONDS.toMillis(10L));
            return this;
        }

        public Builder enableAutoPersistedSubscriptions(boolean enableAutoPersistedSubscriptions) {
            this.enableAutoPersistedSubscriptions = enableAutoPersistedSubscriptions;
            return this;
        }

        public Builder useHttpGetMethodForQueries(boolean useHttpGetMethodForQueries) {
            this.useHttpGetMethodForQueries = useHttpGetMethodForQueries;
            return this;
        }

        public Builder useHttpGetMethodForPersistedQueries(boolean useHttpGetMethodForPersistedQueries) {
            this.useHttpGetMethodForPersistedQueries = useHttpGetMethodForPersistedQueries;
            return this;
        }

        public Builder batchingConfiguration(BatchConfig batchConfig) {
            this.batchConfig = batchConfig;
            return this;
        }

        public ApolloClient build() {
            BatchConfig batchConfig;
            Executor dispatcher;
            HttpCache httpCache;
            Utils.checkNotNull(this.serverUrl, "serverUrl is null");
            ApolloLogger apolloLogger = new ApolloLogger(this.logger);
            Call.Factory callFactory = this.callFactory;
            if (callFactory == null) {
                callFactory = new OkHttpClient();
            }
            if ((httpCache = this.httpCache) != null) {
                callFactory = Builder.addHttpCacheInterceptorIfNeeded(callFactory, httpCache.interceptor());
            }
            if ((dispatcher = this.dispatcher) == null) {
                dispatcher = this.defaultDispatcher();
            }
            ScalarTypeAdapters scalarTypeAdapters = new ScalarTypeAdapters(Collections.unmodifiableMap(this.customTypeAdapters));
            ApolloStore apolloStore = this.apolloStore;
            Optional<NormalizedCacheFactory> cacheFactory = this.cacheFactory;
            Optional<CacheKeyResolver> cacheKeyResolver = this.cacheKeyResolver;
            if (cacheFactory.isPresent() && cacheKeyResolver.isPresent()) {
                NormalizedCache normalizedCache = cacheFactory.get().createChain(RecordFieldJsonAdapter.create());
                apolloStore = new RealApolloStore(normalizedCache, cacheKeyResolver.get(), scalarTypeAdapters, dispatcher, apolloLogger);
            }
            SubscriptionManager subscriptionManager = this.subscriptionManager;
            Optional<SubscriptionTransport.Factory> subscriptionTransportFactory = this.subscriptionTransportFactory;
            if (subscriptionTransportFactory.isPresent()) {
                final ApolloStore finalApolloStore = apolloStore;
                Function0<ResponseNormalizer<Map<String, Object>>> responseNormalizer = new Function0<ResponseNormalizer<Map<String, Object>>>(){

                    @Override
                    public ResponseNormalizer<Map<String, Object>> invoke() {
                        return finalApolloStore.networkResponseNormalizer();
                    }
                };
                subscriptionManager = new RealSubscriptionManager(scalarTypeAdapters, subscriptionTransportFactory.get(), this.subscriptionConnectionParams, dispatcher, this.subscriptionHeartbeatTimeout, responseNormalizer, this.enableAutoPersistedSubscriptions);
            }
            if ((batchConfig = this.batchConfig) == null) {
                batchConfig = new BatchConfig();
            }
            return new ApolloClient(this.serverUrl, callFactory, httpCache, apolloStore, scalarTypeAdapters, dispatcher, this.defaultHttpCachePolicy, this.defaultResponseFetcher, this.defaultCacheHeaders, apolloLogger, Collections.unmodifiableList(this.applicationInterceptors), Collections.unmodifiableList(this.applicationInterceptorFactories), this.autoPersistedOperationsInterceptorFactory, this.enableAutoPersistedQueries, subscriptionManager, this.useHttpGetMethodForQueries, this.useHttpGetMethodForPersistedQueries, this.writeToNormalizedCacheAsynchronously, batchConfig);
        }

        private Executor defaultDispatcher() {
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(@NotNull Runnable runnable) {
                    return new Thread(runnable, "Apollo Dispatcher");
                }
            });
        }

        private static Call.Factory addHttpCacheInterceptorIfNeeded(Call.Factory callFactory, Interceptor httpCacheInterceptor) {
            if (callFactory instanceof OkHttpClient) {
                OkHttpClient client = (OkHttpClient)callFactory;
                for (Interceptor interceptor : client.interceptors()) {
                    if (!interceptor.getClass().equals(httpCacheInterceptor.getClass())) continue;
                    return callFactory;
                }
                return client.newBuilder().addInterceptor(httpCacheInterceptor).build();
            }
            return callFactory;
        }
    }
}

