/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreationOrchestrator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.IssueNoteBatchUpdateOrchestrator;

@Component
@Transactional(readOnly=true)
public class GitLabNoteBatchOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabNoteBatchOrchestrator.class);
    private final IssueNoteBatchCreationOrchestrator batchCreator = new IssueNoteBatchCreationOrchestrator();
    private final IssueNoteBatchUpdateOrchestrator batchUpdater = new IssueNoteBatchUpdateOrchestrator();

    public BatchProcessResult processNotes(GitLabClient client, List<NoteProcessInfo> noteProcessInfos) {
        List<NoteProcessInfo> obsoleteNotes = noteProcessInfos.stream().filter(noteProcessInfo -> !noteProcessInfo.canEdit).toList();
        List<NoteProcessInfo> toUpdate = noteProcessInfos.stream().filter(NoteProcessInfo::isUpdate).filter(noteProcessInfo -> noteProcessInfo.canEdit).toList();
        LOGGER.trace("Processing {} notes to update", (Object)toUpdate.size());
        IssueNoteBatchUpdateOrchestrator.BatchUpdateResult batchUpdateResult = this.batchUpdater.updateNotes(client, toUpdate);
        List<NoteProcessInfo> toCreate = noteProcessInfos.stream().filter(NoteProcessInfo::isCreation).collect(Collectors.toList());
        List<NoteProcessInfo> withUpdatePermissionErrors = GitLabNoteBatchOrchestrator.findNotesWithUpdatePermissionErrors(batchUpdateResult, toUpdate);
        toCreate.addAll(withUpdatePermissionErrors);
        toCreate.addAll(obsoleteNotes);
        ArrayList<NoteProcessInfo> notesToMarkAsObsolete = new ArrayList<NoteProcessInfo>(obsoleteNotes);
        notesToMarkAsObsolete.addAll(withUpdatePermissionErrors);
        LOGGER.trace("Processing {} notes to create", (Object)toCreate.size());
        IssueNoteBatchCreationOrchestrator.BatchCreationResult batchCreationResult = this.batchCreator.createNotes(client, toCreate);
        return new BatchProcessResult(batchCreationResult, batchUpdateResult, notesToMarkAsObsolete);
    }

    private static List<NoteProcessInfo> findNotesWithUpdatePermissionErrors(IssueNoteBatchUpdateOrchestrator.BatchUpdateResult batchUpdateResult, List<NoteProcessInfo> toUpdate) {
        ArrayList<NoteProcessInfo> toCreate = new ArrayList<NoteProcessInfo>();
        if (!batchUpdateResult.getErrorsByIssueId().isEmpty()) {
            for (String issueId : batchUpdateResult.getErrorsByIssueId().keySet()) {
                List errors = batchUpdateResult.getErrorsByIssueId().getOrDefault(issueId, Collections.emptyList());
                if (!errors.stream().anyMatch(error -> error.contains("you don't have permission to perform this action"))) continue;
                toUpdate.stream().filter(noteInfo -> noteInfo.issueGlobalId.equals(issueId)).findFirst().ifPresent(note -> {
                    toCreate.add(NoteProcessInfo.forUpdate(note.requirementIds, issueId, note.noteBody, note.existingNoteGlobalId, false));
                    batchUpdateResult.addFallbackToCreate(issueId);
                });
            }
        }
        if (!toCreate.isEmpty()) {
            LOGGER.debug("Found {} notes to create because of update permission errors. A new note will be created", (Object)toCreate.size());
        }
        return toCreate;
    }

    public record BatchProcessResult(IssueNoteBatchCreationOrchestrator.BatchCreationResult batchCreationResult, IssueNoteBatchUpdateOrchestrator.BatchUpdateResult batchUpdateResult, List<NoteProcessInfo> notesToMarkAsObsolete) {
    }
}

