/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.domain;

import java.util.Date;
import java.util.List;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabEntityHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabMilestone;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.IssueState;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SyncedRequirementPathHelper;

public class GitLabIssue {
    private final String globalId;
    private final String id;
    private final Integer iid;
    private final String title;
    private final String webUrl;
    private final Integer projectId;
    private final String path;
    private final String description;
    private final String author;
    private final Date createdAt;
    private final String updatedBy;
    private final Date updatedAt;
    private final GitLabMilestone milestone;
    private final IterationDto iteration;
    private final String webPath;
    private final List<String> labels;
    private final Integer weight;
    private final Date dueDate;
    private final boolean confidential;
    private final boolean discussionLocked;
    private final String epic;
    private final List<String> assignees;
    private final List<GitLabNote> notes;
    private final IssueState state;

    public GitLabIssue(String globalId, int iid, String title, String webUrl, Integer projectId, String path, String description, String author, Date createdAt, String updatedBy, Date updatedAt, GitLabMilestone milestone, IterationDto iteration, String webPath, List<String> labels, Integer weight, Date dueDate, boolean confidential, boolean discussionLocked, String epic, List<String> assignees, List<GitLabNote> notes, IssueState state) {
        this.globalId = globalId;
        this.id = GitLabEntityHelper.extractIssueIdFromGID(globalId);
        this.iid = iid;
        this.title = title;
        this.webUrl = webUrl;
        this.projectId = projectId;
        this.path = path;
        this.description = description;
        this.author = author;
        this.createdAt = createdAt;
        this.updatedBy = updatedBy;
        this.updatedAt = updatedAt;
        this.labels = labels;
        this.milestone = milestone;
        this.weight = weight;
        this.dueDate = dueDate;
        this.confidential = confidential;
        this.discussionLocked = discussionLocked;
        this.iteration = iteration;
        this.webPath = webPath;
        this.epic = epic;
        this.assignees = assignees;
        this.notes = notes;
        this.state = state;
    }

    public static GitLabIssue community(String globalId, int iid, String title, String webUrl, Integer projectId, String path, String description, String author, Date createdAt, String updatedBy, Date updatedAt, GitLabMilestone milestone, String webPath, List<String> labels, Date dueDate, boolean confidential, boolean discussionLocked, List<String> assignees, List<GitLabNote> notes, IssueState state) {
        return new GitLabIssue(globalId, iid, title, webUrl, projectId, path, description, author, createdAt, updatedBy, updatedAt, milestone, null, webPath, labels, null, dueDate, confidential, discussionLocked, null, assignees, notes, state);
    }

    public String getGlobalId() {
        return this.globalId;
    }

    public String getId() {
        return this.id;
    }

    public Integer getIid() {
        return this.iid;
    }

    public String getTitle() {
        return this.title;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public String getProjectPath() {
        String fullRelativePath = SyncedRequirementPathHelper.getRelativePathFromWebPath(this.webPath);
        String[] pathAsArray = fullRelativePath.split("/");
        return pathAsArray[pathAsArray.length - 1];
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public GitLabMilestone getMilestone() {
        return this.milestone;
    }

    public IterationDto getIteration() {
        return this.iteration;
    }

    public String getWebPath() {
        return this.webPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    public boolean isDiscussionLocked() {
        return this.discussionLocked;
    }

    public String getEpic() {
        return this.epic;
    }

    public List<String> getAssignees() {
        return this.assignees;
    }

    public List<GitLabNote> getNotes() {
        return this.notes;
    }

    public IssueState getState() {
        return this.state;
    }

    public GitLabIssue withPath(String path) {
        return new GitLabIssue(this.globalId, this.iid, this.title, this.webUrl, this.projectId, path, this.description, this.author, this.createdAt, this.updatedBy, this.updatedAt, this.milestone, this.iteration, this.webPath, this.labels, this.weight, this.dueDate, this.confidential, this.discussionLocked, this.epic, this.assignees, this.notes, this.state);
    }

    public GitLabIssue withNotes(List<GitLabNote> notes) {
        return new GitLabIssue(this.globalId, this.iid, this.title, this.webUrl, this.projectId, this.path, this.description, this.author, this.createdAt, this.updatedBy, this.updatedAt, this.milestone, this.iteration, this.webPath, this.labels, this.weight, this.dueDate, this.confidential, this.discussionLocked, this.epic, this.assignees, notes, this.state);
    }
}

