/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.okhttp3.internal.cache2;

import java.io.IOException;
import java.nio.channels.FileChannel;
import xsquash4gitlab.okio.Buffer;

final class FileOperator {
    private final FileChannel fileChannel;

    FileOperator(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public void write(long pos, Buffer source2, long byteCount) throws IOException {
        if (byteCount < 0L || byteCount > source2.size()) {
            throw new IndexOutOfBoundsException();
        }
        while (byteCount > 0L) {
            long bytesWritten = this.fileChannel.transferFrom(source2, pos, byteCount);
            pos += bytesWritten;
            byteCount -= bytesWritten;
        }
    }

    public void read(long pos, Buffer sink2, long byteCount) throws IOException {
        if (byteCount < 0L) {
            throw new IndexOutOfBoundsException();
        }
        while (byteCount > 0L) {
            long bytesRead = this.fileChannel.transferTo(pos, byteCount, sink2);
            pos += bytesRead;
            byteCount -= bytesRead;
        }
    }
}

