/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.internal.batch;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import xsquash4gitlab.com.apollographql.apollo.api.ScalarTypeAdapters;
import xsquash4gitlab.com.apollographql.apollo.api.internal.json.BufferedSourceJsonReader;
import xsquash4gitlab.com.apollographql.apollo.api.internal.json.JsonWriter;
import xsquash4gitlab.com.apollographql.apollo.api.internal.json.ResponseJsonStreamReader;
import xsquash4gitlab.com.apollographql.apollo.api.internal.json.Utils;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptor;
import xsquash4gitlab.com.apollographql.apollo.internal.batch.BatchHttpCall;
import xsquash4gitlab.com.apollographql.apollo.internal.batch.BatchHttpCallImpl;
import xsquash4gitlab.com.apollographql.apollo.internal.batch.QueryToBatch;
import xsquash4gitlab.com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import xsquash4gitlab.kotlin.Metadata;
import xsquash4gitlab.kotlin.Unit;
import xsquash4gitlab.kotlin.collections.CollectionsKt;
import xsquash4gitlab.kotlin.io.CloseableKt;
import xsquash4gitlab.kotlin.jvm.internal.Intrinsics;
import xsquash4gitlab.kotlin.sequences.SequencesKt;
import xsquash4gitlab.okhttp3.Call;
import xsquash4gitlab.okhttp3.Callback;
import xsquash4gitlab.okhttp3.HttpUrl;
import xsquash4gitlab.okhttp3.Request;
import xsquash4gitlab.okhttp3.RequestBody;
import xsquash4gitlab.okhttp3.Response;
import xsquash4gitlab.okhttp3.ResponseBody;
import xsquash4gitlab.okio.Buffer;
import xsquash4gitlab.okio.BufferedSource;
import xsquash4gitlab.okio.ByteString;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxsquash4gitlab/com/apollographql/apollo/internal/batch/BatchHttpCallImpl;", "Lxsquash4gitlab/com/apollographql/apollo/internal/batch/BatchHttpCall;", "queryList", "", "Lxsquash4gitlab/com/apollographql/apollo/internal/batch/QueryToBatch;", "serverUrl", "Lxsquash4gitlab/okhttp3/HttpUrl;", "httpCallFactory", "Lxsquash4gitlab/okhttp3/Call$Factory;", "scalarTypeAdapters", "Lxsquash4gitlab/com/apollographql/apollo/api/ScalarTypeAdapters;", "(Ljava/util/List;Lokhttp3/HttpUrl;Lokhttp3/Call$Factory;Lcom/apollographql/apollo/api/ScalarTypeAdapters;)V", "createBatchRequestJsonBody", "Lxsquash4gitlab/okio/ByteString;", "queryRequestBodyList", "execute", "", "extractResponseListFromBody", "Lxsquash4gitlab/okhttp3/Response;", "response", "apollo-runtime"})
public final class BatchHttpCallImpl
implements BatchHttpCall {
    @NotNull
    private final List<QueryToBatch> queryList;
    @NotNull
    private final HttpUrl serverUrl;
    @NotNull
    private final Call.Factory httpCallFactory;
    @NotNull
    private final ScalarTypeAdapters scalarTypeAdapters;

    public BatchHttpCallImpl(@NotNull List<QueryToBatch> queryList, @NotNull HttpUrl serverUrl, @NotNull Call.Factory httpCallFactory, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        Intrinsics.checkParameterIsNotNull(queryList, "queryList");
        Intrinsics.checkParameterIsNotNull(serverUrl, "serverUrl");
        Intrinsics.checkParameterIsNotNull(httpCallFactory, "httpCallFactory");
        Intrinsics.checkParameterIsNotNull(scalarTypeAdapters, "scalarTypeAdapters");
        this.queryList = queryList;
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.scalarTypeAdapters = scalarTypeAdapters;
    }

    @Override
    public void execute() {
        boolean bl = false;
        List queryRequestBodyList = new ArrayList();
        for (QueryToBatch query : this.queryList) {
            query.getCallback().onFetch(ApolloInterceptor.FetchSourceType.NETWORK);
            queryRequestBodyList.add(query.getRequest().operation.composeRequestBody(query.getRequest().autoPersistQueries, query.getRequest().sendQueryDocument, this.scalarTypeAdapters));
        }
        RequestBody batchRequestBody = RequestBody.create(ApolloServerInterceptor.Companion.getMEDIA_TYPE(), this.createBatchRequestJsonBody(queryRequestBodyList));
        Request.Builder requestBuilder = new Request.Builder().url(this.serverUrl).header("Accept", "application/json").header("Content-Type", "application/json").post(batchRequestBody);
        ApolloInterceptor.InterceptorRequest firstRequest2 = (ApolloInterceptor.InterceptorRequest)SequencesKt.first(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.queryList), execute.firstRequest.1.INSTANCE));
        for (String header : firstRequest2.requestHeaders.headers()) {
            String value = firstRequest2.requestHeaders.headerValue(header);
            requestBuilder.header(header, value);
        }
        Call httpCall = this.httpCallFactory.newCall(requestBuilder.build());
        httpCall.enqueue(new Callback(this){
            final /* synthetic */ BatchHttpCallImpl this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull(call, "call");
                Intrinsics.checkParameterIsNotNull(response, "response");
                try {
                    List responseBodies = BatchHttpCallImpl.access$extractResponseListFromBody(this.this$0, response);
                    if (responseBodies.size() != BatchHttpCallImpl.access$getQueryList$p(this.this$0).size()) {
                        throw new ApolloException("Batch response has missing data, expected " + BatchHttpCallImpl.access$getQueryList$p(this.this$0).size() + ", got " + responseBodies.size());
                    }
                    Iterable $this$forEachIndexed$iv = BatchHttpCallImpl.access$getQueryList$p(this.this$0);
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void queryToBatch;
                        int n = index$iv++;
                        boolean bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        QueryToBatch queryToBatch2 = (QueryToBatch)item$iv;
                        int index = n;
                        boolean bl2 = false;
                        E e = responseBodies.get(index);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        Response response2 = (Response)e;
                        boolean bl5 = false;
                        queryToBatch.getCallback().onResponse(new ApolloInterceptor.InterceptorResponse(response2));
                        queryToBatch.getCallback().onCompleted();
                    }
                }
                catch (Exception exception) {
                    Iterable $this$forEach$iv = BatchHttpCallImpl.access$getQueryList$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        QueryToBatch it = (QueryToBatch)element$iv;
                        boolean bl = false;
                        String message = "Failed to parse batch http response for operation '" + it.getRequest().operation.name().name() + '\'';
                        it.getCallback().onFailure(new ApolloException(message, exception));
                    }
                }
                finally {
                    response.close();
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull(call, "call");
                Intrinsics.checkParameterIsNotNull(e, "e");
                Iterable $this$forEach$iv = BatchHttpCallImpl.access$getQueryList$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    QueryToBatch it = (QueryToBatch)element$iv;
                    boolean bl = false;
                    String message = "Failed to execute http call for operation '" + it.getRequest().operation.name().name() + '\'';
                    it.getCallback().onFailure(new ApolloException(message, e));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteString createBatchRequestJsonBody(List<? extends ByteString> queryRequestBodyList) {
        Buffer buffer = new Buffer();
        Closeable closeable = JsonWriter.Companion.of(buffer);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl3 = false;
            JsonWriter $this$writeArray$iv = writer;
            boolean $i$f$writeArray = false;
            $this$writeArray$iv.beginArray();
            JsonWriter $this$createBatchRequestJsonBody_u24lambda_u2d2_u24lambda_u2d1 = $this$writeArray$iv;
            boolean bl4 = false;
            Iterable $this$forEach$iv = queryRequestBodyList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ByteString it = (ByteString)element$iv;
                boolean bl5 = false;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkExpressionValueIsNotNull(charset, "defaultCharset()");
                $this$createBatchRequestJsonBody_u24lambda_u2d2_u24lambda_u2d1.jsonValue(it.string(charset));
            }
            $this$writeArray$iv.endArray();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return buffer.readByteString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Response> extractResponseListFromBody(Response response) {
        List list;
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            list = null;
        } else {
            BufferedSource bufferedSource = responseBody.source();
            if (bufferedSource == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Object object;
                Collection collection;
                Object object2;
                Iterable $this$map$iv;
                List list2;
                BufferedSource bufferedSource2 = bufferedSource;
                boolean bl = false;
                boolean bl2 = false;
                BufferedSource body = bufferedSource2;
                boolean bl3 = false;
                ResponseJsonStreamReader reader = new ResponseJsonStreamReader(new BufferedSourceJsonReader(body));
                List<Object> list3 = reader.readList();
                if (list3 == null) {
                    list2 = null;
                } else {
                    void $this$mapTo$iv$iv2;
                    $this$map$iv = list3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    object2 = $this$mapTo$iv$iv2.iterator();
                    while (object2.hasNext()) {
                        Object item$iv$iv;
                        Object t = item$iv$iv = object2.next();
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        Buffer buffer = new Buffer();
                        Closeable closeable = JsonWriter.Companion.of(buffer);
                        boolean bl5 = false;
                        boolean bl6 = false;
                        Throwable throwable = null;
                        try {
                            void dataMap;
                            JsonWriter writer = (JsonWriter)closeable;
                            boolean bl7 = false;
                            Utils.writeToJson(dataMap, writer);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, throwable);
                        }
                        object = buffer.readByteString();
                        collection.add(object);
                    }
                    list2 = (List)destination$iv$iv;
                }
                List list4 = list2;
                if (list4 == null) {
                    throw new ApolloException("Unable to extract individual responses from batch response body");
                }
                List responseList = list4;
                Iterable $this$map$iv2 = responseList;
                boolean $i$f$map = false;
                $this$map$iv = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void responseBodyString;
                    object2 = (ByteString)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl8 = false;
                    object = response.newBuilder().body(ResponseBody.create(ApolloServerInterceptor.Companion.getMEDIA_TYPE(), (ByteString)responseBodyString)).build();
                    collection.add(object);
                }
                list = (List)destination$iv$iv;
            }
        }
        List list5 = list;
        if (list5 == null) {
            throw new ApolloException("Unable to read batch response body");
        }
        return list5;
    }

    public static final /* synthetic */ List access$extractResponseListFromBody(BatchHttpCallImpl $this, Response response) {
        return $this.extractResponseListFromBody(response);
    }

    public static final /* synthetic */ List access$getQueryList$p(BatchHttpCallImpl $this) {
        return $this.queryList;
    }
}

