/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting;

import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.GitLabReportingLocaleHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.ObsoleteNoteMarker;

@Transactional(readOnly=true)
@Service
public class ObsoleteNoteMarkerImpl
implements ObsoleteNoteMarker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObsoleteNoteMarkerImpl.class);
    private final GitLabReportingLocaleHelper gitLabReportingLocaleHelper;

    public ObsoleteNoteMarkerImpl(GitLabReportingLocaleHelper gitLabReportingLocaleHelper) {
        this.gitLabReportingLocaleHelper = gitLabReportingLocaleHelper;
    }

    @Override
    public void markAsObsolete(GitLabClient client, String issueGlobalId, String obsoleteNoteId, String newNoteUrl) {
        GitLabClient.Page<List<GitLabNote>> page;
        if (obsoleteNoteId == null || newNoteUrl == null) {
            LOGGER.trace("Obsolete note ID or new note URL is null, skipping marking as obsolete.", new Object[0]);
            return;
        }
        ArrayList allNotes = new ArrayList();
        String cursor = null;
        do {
            page = client.getNoteClient().getIssueNotesPage(issueGlobalId, cursor);
            allNotes.addAll(page.items());
        } while ((cursor = page.endCursor()) != null);
        String discussionId = allNotes.stream().filter(note -> note.globalId().equals(obsoleteNoteId)).findFirst().map(GitLabNote::discussionId).orElseThrow(() -> new IllegalStateException("Note not found: " + obsoleteNoteId));
        String noteContent = this.gitLabReportingLocaleHelper.buildObsoleteWarningNote(newNoteUrl);
        client.getNoteClient().createDiscussionNote(issueGlobalId, discussionId, noteContent);
    }
}

