/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabEntityHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.service.FieldMappingService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.LocaleWithFallback;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementHierarchyHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementMover;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronizedFolderService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.finder.RemoteRequirementFinder;
import org.squashtest.tm.plugin.xsquash4gitlab.service.finder.RemoteRequirementFinderFactory;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.container.RequirementVersionInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Scope(value="prototype")
@Component(value="squash.tm.plugin.xsquash4gitlab.RequirementImporter")
@Transactional
public class RequirementImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementImporter.class);
    private final RemoteRequirementFinderFactory remoteRequirementFinderFactory;
    private final FacilityImpl facility;
    private final InternationalizationHelper internationalizationHelper;
    private final RequirementMover requirementMover;
    private final EntityPathHeaderService pathService;
    private final MilestoneDao milestoneDao;
    private final FieldMappingService fieldMappingService;
    private final SynchronizedFolderService synchronizedFolderService;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public RequirementImporter(RemoteRequirementFinderFactory remoteRequirementFinderFactory, FacilityImpl facility, InternationalizationHelper internationalizationHelper, RequirementMover requirementMover, EntityPathHeaderService pathService, MilestoneDao milestoneDao, SynchronizedFolderService synchronizedFolderService, FieldMappingService fieldMappingService) {
        this.remoteRequirementFinderFactory = remoteRequirementFinderFactory;
        this.facility = facility;
        this.internationalizationHelper = internationalizationHelper;
        this.requirementMover = requirementMover;
        this.pathService = pathService;
        this.milestoneDao = milestoneDao;
        this.synchronizedFolderService = synchronizedFolderService;
        this.fieldMappingService = fieldMappingService;
    }

    public void importGitLabIssues(List<GitLabIssue> gitLabIssues, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        RemoteRequirementFinder.Result finderResult = this.remoteRequirementFinderFactory.create().findRemoteRequirementsToUpdate(gitLabIssues, gitLabRemoteSynchronisation.getRemoteSynchronisation().getId());
        Long rootFolderId = this.prepareRootFolder(gitLabRemoteSynchronisation);
        String rootFolderPath = this.requirementMover.getFolderPath(rootFolderId);
        this.prepareSubFolders(gitLabRemoteSynchronisation, gitLabIssues);
        UpdateDataCache updateDataCache = this.getUpdateCache(finderResult);
        HashMap<RequirementVersionInstruction, GitLabIssue> instructions = new HashMap<RequirementVersionInstruction, GitLabIssue>();
        for (GitLabIssue gitLabIssue : gitLabIssues) {
            if (!finderResult.shouldUpdateOrCreate(gitLabIssue)) continue;
            RequirementVersionInstruction instruction = this.buildInstruction(gitLabIssue, finderResult, gitLabRemoteSynchronisation, rootFolderPath, updateDataCache);
            instructions.put(instruction, gitLabIssue);
        }
        this.processInstructions(gitLabRemoteSynchronisation, instructions, rootFolderPath, finderResult);
    }

    private UpdateDataCache getUpdateCache(RemoteRequirementFinder.Result finderResult) {
        Set<Long> updatedRequirementIds = finderResult.getToUpdateRequirementIds();
        if (updatedRequirementIds.isEmpty()) {
            return new UpdateDataCache(Collections.emptyMap(), Collections.emptyMap());
        }
        return new UpdateDataCache(this.pathService.buildRequirementPathsByIds(updatedRequirementIds), this.milestoneDao.findRequirementMilestoneLabelsByReqIds(updatedRequirementIds));
    }

    private void processInstructions(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, Map<RequirementVersionInstruction, GitLabIssue> instructions, String rootFolderPath, RemoteRequirementFinder.Result finderResult) {
        RequirementVersionInstructionContainer container = new RequirementVersionInstructionContainer(new ArrayList<RequirementVersionInstruction>(instructions.keySet()));
        container.executeInstructions((Facility)this.facility, gitLabRemoteSynchronisation.getProject());
        for (Map.Entry<RequirementVersionInstruction, GitLabIssue> entry : instructions.entrySet()) {
            RequirementVersionInstruction instruction = entry.getKey();
            GitLabIssue gitLabIssue = entry.getValue();
            if (instruction.hasCriticalErrors()) {
                this.logCriticalErrors(instruction.getLogTrain());
                continue;
            }
            if (instruction.getMode() == ImportMode.CREATE) {
                this.processExtenderCreation(instruction, gitLabIssue, gitLabRemoteSynchronisation);
                continue;
            }
            this.processExtenderUpdate(instruction, gitLabIssue, gitLabRemoteSynchronisation, rootFolderPath, finderResult);
        }
    }

    private void processExtenderUpdate(RequirementVersionInstruction instruction, GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String rootFolderPath, RemoteRequirementFinder.Result finderResult) {
        RequirementSyncExtender syncExtender = finderResult.knownExtenders.get(GitLabEntityHelper.getKey(gitLabIssue));
        String currentRequirementPath = instruction.getSourcePath();
        this.moveExistingRequirementIfNeeded(gitLabIssue, gitLabRemoteSynchronisation, syncExtender, rootFolderPath, currentRequirementPath);
        LogTrain logs = instruction.getLogTrain();
        this.logTrace(String.format("Import went with no critical errors (%s entries)", logs.getEntries().size()));
        this.updateSyncExtender(syncExtender, gitLabIssue, gitLabRemoteSynchronisation);
    }

    public void processExtenderCreation(RequirementVersionInstruction instruction, GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        LogTrain logs = instruction.getLogTrain();
        this.logTrace(String.format("Import went with no critical errors (%s entries)", logs.getEntries().size()));
        this.createSyncExtender(instruction, gitLabIssue, gitLabRemoteSynchronisation);
    }

    private Long prepareRootFolder(GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        return this.synchronizedFolderService.prepareRootTargetFolder(gitLabRemoteSynchronisation.getRemoteSynchronisation());
    }

    private void prepareSubFolders(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, List<GitLabIssue> gitLabIssues) {
        this.synchronizedFolderService.prepareSubFolders(gitLabRemoteSynchronisation, gitLabIssues);
    }

    private RequirementVersionInstruction buildInstruction(GitLabIssue gitLabIssue, RemoteRequirementFinder.Result finderResult, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String rootFolderPath, UpdateDataCache updateCache) {
        boolean isKnownSyncExtender = finderResult.isKnownSyncExtender(GitLabEntityHelper.getKey(gitLabIssue));
        if (isKnownSyncExtender) {
            return this.createUpdateInstruction(gitLabIssue, gitLabRemoteSynchronisation, finderResult, updateCache);
        }
        return this.createCreateInstruction(gitLabIssue, gitLabRemoteSynchronisation, rootFolderPath);
    }

    private RequirementVersionInstruction createCreateInstruction(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String rootFolderPath) {
        String newRequirementPath = this.requirementMover.buildRequirementPath(gitLabRemoteSynchronisation, gitLabIssue, rootFolderPath);
        RequirementVersionInstruction instruction = this.createBaseInstruction(gitLabIssue, gitLabRemoteSynchronisation, newRequirementPath);
        instruction.setMode(ImportMode.CREATE);
        this.logTrace("attempting to create requirement version '" + ((RequirementVersionTarget)instruction.getTarget()).getPath() + "'");
        return instruction;
    }

    private RequirementVersionInstruction createUpdateInstruction(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, RemoteRequirementFinder.Result finderResult, UpdateDataCache updateCache) {
        RequirementSyncExtender syncExtender = finderResult.knownExtenders.get(GitLabEntityHelper.getKey(gitLabIssue));
        Long requirementId = syncExtender.getRequirement().getId();
        String currentRequirementPath = updateCache.getPath(requirementId);
        RequirementVersionInstruction instruction = this.createBaseInstruction(gitLabIssue, gitLabRemoteSynchronisation, currentRequirementPath);
        instruction.setMode(ImportMode.UPDATE);
        instruction.setMilestones((String[])updateCache.getMilestoneLabels(requirementId).toArray(String[]::new));
        this.logTrace("attempting to update requirement version '" + currentRequirementPath + "' with new data");
        return instruction;
    }

    private void moveExistingRequirementIfNeeded(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, RequirementSyncExtender syncExtender, String rootFolderPath, String currentRequirementPath) {
        boolean shouldMoveRequirement;
        String desiredRequirementPath = this.requirementMover.buildRequirementPath(gitLabRemoteSynchronisation, gitLabIssue, rootFolderPath);
        boolean requirementHasDesiredPath = desiredRequirementPath.equals(currentRequirementPath);
        if (!requirementHasDesiredPath && (shouldMoveRequirement = RequirementHierarchyHelper.shouldMoveSyncedRequirement(gitLabRemoteSynchronisation, rootFolderPath, currentRequirementPath, true, gitLabIssue, true))) {
            this.requirementMover.updateRequirementPath(gitLabIssue, gitLabRemoteSynchronisation, syncExtender, rootFolderPath);
        }
    }

    private RequirementVersionInstruction createBaseInstruction(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String requirementPath) {
        RequirementVersion version = new RequirementVersion();
        version.setVersionNumber(1);
        new Requirement(version);
        Long projectId = gitLabRemoteSynchronisation.getRemoteSynchronisation().getProject().getId();
        CustomFieldValueCollection customFieldValueCollection = new CustomFieldValueCollection();
        this.populate(gitLabRemoteSynchronisation, projectId, version, gitLabIssue, customFieldValueCollection);
        RequirementTarget requirementTarget = new RequirementTarget(requirementPath);
        requirementTarget.setRemoteKey(GitLabEntityHelper.getKey(gitLabIssue));
        requirementTarget.setRemoteSynchronisationId(Long.valueOf(gitLabRemoteSynchronisation.getRemoteSynchronisation().getId()));
        RequirementVersionTarget requirementVersionTarget = new RequirementVersionTarget(requirementTarget, null);
        RequirementVersionInstruction instruction = new RequirementVersionInstruction(requirementVersionTarget, version);
        for (Map.Entry<String, String> cuf : customFieldValueCollection.entrySet()) {
            instruction.addCustomField(cuf.getKey(), cuf.getValue());
        }
        requirementVersionTarget.setVersion(Integer.valueOf(1));
        return instruction;
    }

    private void populate(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, Long projectId, RequirementVersion version, GitLabIssue gitLabIssue, CustomFieldValueCollection customFieldValueCollection) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Parsing issue '%s'", gitLabIssue.getId()));
        }
        this.fieldMappingService.processFieldMappings(gitLabRemoteSynchronisation, projectId, version, gitLabIssue, customFieldValueCollection);
    }

    private void createSyncExtender(RequirementVersionInstruction instruction, GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        Requirement requirement = instruction.getRequirementVersion().getRequirement();
        if (requirement.getSyncExtender() != null) {
            throw new IllegalArgumentException("this was supposed to be a new requirement !");
        }
        RequirementSyncExtender extender = new RequirementSyncExtender();
        this.updateSyncExtender(extender, gitLabIssue, gitLabRemoteSynchronisation);
        requirement.setSyncExtender(extender);
        extender.setRequirement(requirement);
        this.entityManager.persist((Object)extender);
    }

    private void updateSyncExtender(RequirementSyncExtender extender, GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        String url = gitLabIssue.getWebUrl();
        String issueKey = GitLabEntityHelper.getKey(gitLabIssue);
        extender.setServer(gitLabRemoteSynchronisation.getRemoteSynchronisation().getServer());
        extender.setRemoteProjectId(gitLabIssue.getProjectId().toString());
        extender.setRemoteSynchronisation(gitLabRemoteSynchronisation.getRemoteSynchronisation());
        extender.setRemoteReqId(issueKey);
        extender.setRemoteLastUpdated(gitLabIssue.getUpdatedAt());
        try {
            extender.setRemoteUrl(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            this.logTrace("could not set url correctly for issue '" + issueKey + "', offending url being '" + url + "'");
        }
    }

    private void logCriticalErrors(LogTrain logs) {
        if (!this.isLogEnabled()) {
            return;
        }
        this.logTrace("Some critical errors occurred during requirement import :");
        for (LogEntry log : logs.getEntries()) {
            if (log.getStatus() != ImportStatus.FAILURE) continue;
            RequirementVersionTarget target = (RequirementVersionTarget)log.getTarget();
            String localeMessage = this.internationalizationHelper.getMessage(log.getI18nError(), log.getErrorArgs(), log.getI18nError(), LocaleWithFallback.getLocaleWithFallback());
            this.logTrace(target.getPath() + " : " + localeMessage);
        }
    }

    private boolean isLogEnabled() {
        return LOGGER.isTraceEnabled();
    }

    private void logTrace(String message) {
        if (this.isLogEnabled()) {
            LOGGER.trace(message);
        }
    }

    static class CustomFieldValueCollection {
        private final Map<String, String> customFieldValues = new HashMap<String, String>();

        CustomFieldValueCollection() {
        }

        void setValue(String code, String value) {
            this.customFieldValues.put(code, value);
        }

        Iterable<Map.Entry<String, String>> entrySet() {
            return this.customFieldValues.entrySet();
        }

        public Map<String, String> c() {
            return this.customFieldValues;
        }

        public Map<String, String> getCustomFieldValues() {
            return this.customFieldValues;
        }
    }

    private record UpdateDataCache(Map<Long, String> requirementPaths, Map<Long, List<String>> milestoneIdsByRequirement) {
        public String getPath(Long requirementId) {
            return this.requirementPaths.get(requirementId);
        }

        public List<String> getMilestoneLabels(Long requirementId) {
            return this.milestoneIdsByRequirement.getOrDefault(requirementId, Collections.emptyList());
        }
    }
}

