/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.IssuesQueryBuilderAdapterCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValueId;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.Xsquash4GitLabConfigurationException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.AssigneesFilterBuilderCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.AuthorFilterBuilderCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.FilterBuilderCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.IssueTypeFilterBuilderCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.LabelFilterBuilderCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.MilestoneFilterBuilderCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.StateFilterBuilderCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.TitleAndDescriptionFilterBuilderCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.NegatedIssueFilterInput;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.UnionedIssueFilterInput;

public class GitLabIssueQueryFilterBuildersCommunity {
    private static final Map<SynchronisationFilterValueId, FilterBuilderCommunity> registeredBuilders = new EnumMap<SynchronisationFilterValueId, FilterBuilderCommunity>(SynchronisationFilterValueId.class);

    static {
        registeredBuilders.put(SynchronisationFilterValueId.AUTHOR, new AuthorFilterBuilderCommunity());
        registeredBuilders.put(SynchronisationFilterValueId.ASSIGNEES, new AssigneesFilterBuilderCommunity());
        registeredBuilders.put(SynchronisationFilterValueId.TITLE_AND_DESCRIPTION, new TitleAndDescriptionFilterBuilderCommunity());
        registeredBuilders.put(SynchronisationFilterValueId.STATE, new StateFilterBuilderCommunity());
        registeredBuilders.put(SynchronisationFilterValueId.MILESTONE, new MilestoneFilterBuilderCommunity());
        registeredBuilders.put(SynchronisationFilterValueId.LABEL, new LabelFilterBuilderCommunity());
        registeredBuilders.put(SynchronisationFilterValueId.TYPE, new IssueTypeFilterBuilderCommunity());
    }

    public static <B> void appendFilters(IssuesQueryBuilderAdapterCommunity<B> builder, List<SynchronisationFilterValue> filterValues) {
        NegatedIssueFilterInput.Builder notBuilder = NegatedIssueFilterInput.builder();
        UnionedIssueFilterInput.Builder orBuilder = UnionedIssueFilterInput.builder();
        filterValues.forEach(filterValue -> {
            SynchronisationFilterValueId filterId = GitLabIssueQueryFilterBuildersCommunity.getFilterId(filterValue);
            registeredBuilders.get((Object)filterId).appendFilter((SynchronisationFilterValue)filterValue, builder, notBuilder, orBuilder);
        });
        GitLabIssueQueryFilterBuildersCommunity.appendNotFilterIfUsed(notBuilder, builder);
    }

    private static <B> void appendNotFilterIfUsed(NegatedIssueFilterInput.Builder notBuilder, IssuesQueryBuilderAdapterCommunity<B> parentBuilder) {
        NegatedIssueFilterInput builtInput = notBuilder.build();
        if (GitLabIssueQueryFilterBuildersCommunity.isNegatedIssueFilterInputUsed(builtInput)) {
            parentBuilder.not(builtInput);
        }
    }

    private static boolean isNegatedIssueFilterInputUsed(NegatedIssueFilterInput builtInput) {
        return Stream.of(new Object[]{builtInput.assigneeId(), builtInput.assigneeUsernames(), builtInput.authorUsername(), builtInput.iids(), builtInput.labelName(), builtInput.milestoneTitle(), builtInput.milestoneWildcardId(), builtInput.myReactionEmoji(), builtInput.releaseTag(), builtInput.types()}).anyMatch(Objects::nonNull);
    }

    private static SynchronisationFilterValueId getFilterId(SynchronisationFilterValue filterValue) {
        SynchronisationFilterValueId filterId = SynchronisationFilterValueId.valueOf(filterValue.getId());
        if (!registeredBuilders.containsKey((Object)filterId)) {
            throw new Xsquash4GitLabConfigurationException("Unhandled filter type " + filterId.name());
        }
        return filterId;
    }

    private GitLabIssueQueryFilterBuildersCommunity() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }
}

