/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetBoardListIssueIdsCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetBoardListIssueIdsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssueIdsCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssueIdsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssueIdsCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssueIdsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectFilteredBoardIssueIdsCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectFilteredBoardIssueIdsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIssueIdsCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIssueIdsQuery;

public final class GitLabIssueIdsConverter {
    private GitLabIssueIdsConverter() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }

    public static List<String> convertProjectIssueIds(GetProjectIssueIdsQuery.Data queryData) {
        return Optional.ofNullable(queryData).map(GetProjectIssueIdsQuery.Data::project).map(GetProjectIssueIdsQuery.Project::issues).map(GetProjectIssueIdsQuery.Issues::nodes).orElseThrow().stream().filter(Objects::nonNull).map(GetProjectIssueIdsQuery.Node::id).toList();
    }

    public static List<String> convertProjectIssueIdsCommunity(GetProjectIssueIdsCommunityQuery.Data queryData) {
        return Optional.ofNullable(queryData).map(GetProjectIssueIdsCommunityQuery.Data::project).map(GetProjectIssueIdsCommunityQuery.Project::issues).map(GetProjectIssueIdsCommunityQuery.Issues::nodes).orElseThrow().stream().filter(Objects::nonNull).map(GetProjectIssueIdsCommunityQuery.Node::id).toList();
    }

    public static BoardIssueIdsFirstPageResult convertProjectBoardIssueIds(GetProjectFilteredBoardIssueIdsQuery.Data queryData) {
        List boardListNodes = Optional.ofNullable(queryData).map(GetProjectFilteredBoardIssueIdsQuery.Data::project).map(GetProjectFilteredBoardIssueIdsQuery.Project::board).map(GetProjectFilteredBoardIssueIdsQuery.Board::lists).map(GetProjectFilteredBoardIssueIdsQuery.Lists::nodes).orElseThrow();
        List<String> gitlabIssueIds = boardListNodes.stream().map(GetProjectFilteredBoardIssueIdsQuery.Node::issues).filter(Objects::nonNull).map(GetProjectFilteredBoardIssueIdsQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(GetProjectFilteredBoardIssueIdsQuery.Node1::id).toList();
        Map<String, Optional<String>> endCursorByBoardListId = boardListNodes.stream().collect(Collectors.toMap(GetProjectFilteredBoardIssueIdsQuery.Node::id, GitLabIssueIdsConverter::extractEndCursorPremium));
        return new BoardIssueIdsFirstPageResult(gitlabIssueIds, endCursorByBoardListId);
    }

    private static Optional<String> extractEndCursorPremium(GetProjectFilteredBoardIssueIdsQuery.Node boardListNode) {
        return Optional.of(boardListNode).map(GetProjectFilteredBoardIssueIdsQuery.Node::issues).map(GetProjectFilteredBoardIssueIdsQuery.Issues::pageInfo).map(GetProjectFilteredBoardIssueIdsQuery.PageInfo::endCursor);
    }

    public static BoardIssueIdsFirstPageResult convertProjectBoardIssueIdsCommunity(GetProjectFilteredBoardIssueIdsCommunityQuery.Data queryData) {
        List boardListNodes = Optional.ofNullable(queryData).map(GetProjectFilteredBoardIssueIdsCommunityQuery.Data::project).map(GetProjectFilteredBoardIssueIdsCommunityQuery.Project::board).map(GetProjectFilteredBoardIssueIdsCommunityQuery.Board::lists).map(GetProjectFilteredBoardIssueIdsCommunityQuery.Lists::nodes).orElseThrow();
        List<String> gitlabIssueIds = boardListNodes.stream().map(GetProjectFilteredBoardIssueIdsCommunityQuery.Node::issues).filter(Objects::nonNull).map(GetProjectFilteredBoardIssueIdsCommunityQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(GetProjectFilteredBoardIssueIdsCommunityQuery.Node1::id).toList();
        Map<String, Optional<String>> endCursorByBoardListId = boardListNodes.stream().collect(Collectors.toMap(GetProjectFilteredBoardIssueIdsCommunityQuery.Node::id, GitLabIssueIdsConverter::extractEndCursorCommunity));
        return new BoardIssueIdsFirstPageResult(gitlabIssueIds, endCursorByBoardListId);
    }

    private static Optional<String> extractEndCursorCommunity(GetProjectFilteredBoardIssueIdsCommunityQuery.Node boardListNode) {
        return Optional.of(boardListNode).map(GetProjectFilteredBoardIssueIdsCommunityQuery.Node::issues).map(GetProjectFilteredBoardIssueIdsCommunityQuery.Issues::pageInfo).map(GetProjectFilteredBoardIssueIdsCommunityQuery.PageInfo::endCursor);
    }

    public static List<String> convertGroupIssueIds(GetGroupIssueIdsQuery.Data queryData) {
        return Optional.ofNullable(queryData).map(GetGroupIssueIdsQuery.Data::group).map(GetGroupIssueIdsQuery.Group::issues).map(GetGroupIssueIdsQuery.Issues::nodes).orElseThrow().stream().filter(Objects::nonNull).map(GetGroupIssueIdsQuery.Node::id).toList();
    }

    public static List<String> convertGroupIssueIdsCommunity(GetGroupIssueIdsCommunityQuery.Data queryData) {
        return Optional.ofNullable(queryData).map(GetGroupIssueIdsCommunityQuery.Data::group).map(GetGroupIssueIdsCommunityQuery.Group::issues).map(GetGroupIssueIdsCommunityQuery.Issues::nodes).orElseThrow().stream().filter(Objects::nonNull).map(GetGroupIssueIdsCommunityQuery.Node::id).toList();
    }

    public static BoardIssueIdsFirstPageResult convertGroupBoardIssueIds(GetGroupFilteredBoardIssueIdsQuery.Data queryData) {
        List boardListNodes = Optional.ofNullable(queryData).map(GetGroupFilteredBoardIssueIdsQuery.Data::group).map(GetGroupFilteredBoardIssueIdsQuery.Group::board).map(GetGroupFilteredBoardIssueIdsQuery.Board::lists).map(GetGroupFilteredBoardIssueIdsQuery.Lists::nodes).orElseThrow();
        List<String> gitlabIssueIds = boardListNodes.stream().map(GetGroupFilteredBoardIssueIdsQuery.Node::issues).filter(Objects::nonNull).map(GetGroupFilteredBoardIssueIdsQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(GetGroupFilteredBoardIssueIdsQuery.Node1::id).toList();
        Map<String, Optional<String>> endCursorByBoardListId = boardListNodes.stream().collect(Collectors.toMap(GetGroupFilteredBoardIssueIdsQuery.Node::id, GitLabIssueIdsConverter::extractEndCursorPremium));
        return new BoardIssueIdsFirstPageResult(gitlabIssueIds, endCursorByBoardListId);
    }

    private static Optional<String> extractEndCursorPremium(GetGroupFilteredBoardIssueIdsQuery.Node boardListNode) {
        return Optional.of(boardListNode).map(GetGroupFilteredBoardIssueIdsQuery.Node::issues).map(GetGroupFilteredBoardIssueIdsQuery.Issues::pageInfo).map(GetGroupFilteredBoardIssueIdsQuery.PageInfo::endCursor);
    }

    public static BoardIssueIdsFirstPageResult convertGroupBoardIssueIdsCommunity(GetGroupFilteredBoardIssueIdsCommunityQuery.Data queryData) {
        List boardListNodes = Optional.ofNullable(queryData).map(GetGroupFilteredBoardIssueIdsCommunityQuery.Data::group).map(GetGroupFilteredBoardIssueIdsCommunityQuery.Group::board).map(GetGroupFilteredBoardIssueIdsCommunityQuery.Board::lists).map(GetGroupFilteredBoardIssueIdsCommunityQuery.Lists::nodes).orElseThrow();
        List<String> gitlabIssueIds = boardListNodes.stream().map(GetGroupFilteredBoardIssueIdsCommunityQuery.Node::issues).filter(Objects::nonNull).map(GetGroupFilteredBoardIssueIdsCommunityQuery.Issues::nodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(GetGroupFilteredBoardIssueIdsCommunityQuery.Node1::id).toList();
        Map<String, Optional<String>> endCursorByBoardListId = boardListNodes.stream().collect(Collectors.toMap(GetGroupFilteredBoardIssueIdsCommunityQuery.Node::id, GitLabIssueIdsConverter::extractEndCursorCommunity));
        return new BoardIssueIdsFirstPageResult(gitlabIssueIds, endCursorByBoardListId);
    }

    private static Optional<String> extractEndCursorCommunity(GetGroupFilteredBoardIssueIdsCommunityQuery.Node boardListNode) {
        return Optional.of(boardListNode).map(GetGroupFilteredBoardIssueIdsCommunityQuery.Node::issues).map(GetGroupFilteredBoardIssueIdsCommunityQuery.Issues::pageInfo).map(GetGroupFilteredBoardIssueIdsCommunityQuery.PageInfo::endCursor);
    }

    public static List<String> convertBoardListIssueIdsPremium(@Nullable GetBoardListIssueIdsQuery.Data data) {
        return Optional.ofNullable(data).map(GetBoardListIssueIdsQuery.Data::boardList).map(GetBoardListIssueIdsQuery.BoardList::issues).map(GetBoardListIssueIdsQuery.Issues::nodes).orElseThrow().stream().filter(Objects::nonNull).map(GetBoardListIssueIdsQuery.Node::id).toList();
    }

    public static List<String> convertBoardListIssueIdsCommunity(@Nullable GetBoardListIssueIdsCommunityQuery.Data data) {
        return Optional.ofNullable(data).map(GetBoardListIssueIdsCommunityQuery.Data::boardList).map(GetBoardListIssueIdsCommunityQuery.BoardList::issues).map(GetBoardListIssueIdsCommunityQuery.Issues::nodes).orElseThrow().stream().filter(Objects::nonNull).map(GetBoardListIssueIdsCommunityQuery.Node::id).toList();
    }

    public static class BoardIssueIdsFirstPageResult {
        public final List<String> gitLabIssueIds;
        public final Map<String, Optional<String>> endCursorByBoardListId;

        public BoardIssueIdsFirstPageResult(List<String> gitLabIssueIds, Map<String, Optional<String>> endCursorByBoardListId) {
            this.gitLabIssueIds = gitLabIssueIds;
            this.endCursorByBoardListId = endCursorByBoardListId;
        }
    }
}

