/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.request;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

public final class RequestHeaders {
    private final Map<String, String> headerMap;
    public static final RequestHeaders NONE = new RequestHeaders(Collections.emptyMap());

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = RequestHeaders.builder();
        builder.addHeaders(this.headerMap);
        return builder;
    }

    RequestHeaders(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public Set<String> headers() {
        return this.headerMap.keySet();
    }

    @Nullable
    public String headerValue(String header) {
        return this.headerMap.get(header);
    }

    public boolean hasHeader(String headerName) {
        return this.headerMap.containsKey(headerName);
    }

    public static final class Builder {
        private final Map<String, String> headerMap = new LinkedHashMap<String, String>();

        public Builder addHeader(String headerName, String headerValue) {
            this.headerMap.put(headerName, headerValue);
            return this;
        }

        public Builder addHeaders(Map<String, String> headerMap) {
            this.headerMap.putAll(headerMap);
            return this;
        }

        public RequestHeaders build() {
            return new RequestHeaders(this.headerMap);
        }
    }
}

