/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.execplan;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanGitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanRequirement;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.SelectedNode;

@Repository(value="squash.tm.plugin.xsquash4gitlab.execplandao")
public class ExecPlanSynchronizationDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext DSL;
    @Inject
    private CurrentUserHelper currentUserHelper;
    private static final String LOAD_SELECTED_NODE_CPG = "select c.id, 'campaign', c.name, p.id, p.name from Campaign c join c.project p where c.id = :id";
    private static final String LOAD_SELECTED_NODE_IT = "select  it.id, 'iteration', it.name, p.id, p.name from Iteration it join it.campaign c join c.project p where it.id = :id";
    private static final String FIND_ITERATION_NAMES = "select it.name from Iteration it join it.campaign c where c.id = :id";
    private static final String FIND_ITERATION_CUFS = "select cuf from CustomFieldBinding binding join binding.customField cuf join binding.boundProject project where project.id = ( select cpro.id from Campaign c join c.project cpro where c.id = :cpgId ) and binding.boundEntity = :boundEntity order by binding.position asc";
    private static final String FIND_SYNCED_SERVERS = "select distinct serv from RemoteSynchronisation sync join sync.server serv where sync.kind = 'squash.tm.plugin.xsquash4gitlab'";
    private static final String FILTER_SYNC_KEY = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync where sync.kind = 'squash.tm.plugin.xsquash4gitlab' and extender.remoteReqId in (:keys)";
    private static final String FILTER_BUGFIXES_KEY = "select distinct issue.remoteIssueId from Issue issue left join BugTracker bt on bt.id = issue.bugtracker.id where issue.remoteIssueId in (:keys) and bt.kind = 'gitlab.bugtracker'";
    private static final String FILTER_COVERED_REQS = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync inner join extender.requirement req inner join req.versions versions inner join versions.requirementVersionCoverages cov where sync.kind = 'squash.tm.plugin.xsquash4gitlab' and extender.remoteReqId in (:keys)";

    public SelectedNode loadSelectedNode(EntityReference reference) {
        Long id = reference.getId();
        return this.loadSelectedNode(switch (reference.getType()) {
            case EntityType.CAMPAIGN -> LOAD_SELECTED_NODE_CPG;
            case EntityType.ITERATION -> LOAD_SELECTED_NODE_IT;
            default -> throw new IllegalArgumentException("Entity Type '" + String.valueOf(reference.getType()) + "' is not yet supported");
        }, id);
    }

    private SelectedNode loadSelectedNode(String hql, Long entityId) {
        Object[] tuple = (Object[])this.em.createQuery(hql).setParameter("id", (Object)entityId).getSingleResult();
        SelectedNode node = new SelectedNode();
        node.setEntityId((Long)tuple[0]);
        node.setType((String)tuple[1]);
        node.setEntityName((String)tuple[2]);
        node.setProjectId((Long)tuple[3]);
        node.setProjectName((String)tuple[4]);
        return node;
    }

    public boolean isWizardEnabledOnProject(long projectId) {
        return (Integer)this.DSL.selectCount().from((TableLike)Tables.LIBRARY_PLUGIN_BINDING).leftJoin((TableLike)Project.PROJECT).on(Project.PROJECT.CL_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_ID)).where(Project.PROJECT.PROJECT_ID.equal((Object)projectId).and(Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_ID.equal((Object)"squash.tm.plugin.xsquash4gitlab")).and(Tables.LIBRARY_PLUGIN_BINDING.ACTIVE.eq((Object)true))).fetchOne(0, Integer.class) > 0;
    }

    public List<BugTracker> findAllGitLabServers() {
        return this.em.createQuery(FIND_SYNCED_SERVERS).getResultList();
    }

    public Collection<Long> findTestCasesAlreadyPlannedInCampaign(long campaignId) {
        String query = "SELECT DISTINCT referencedTestCase.id\nFROM CampaignTestPlanItem item\nJOIN item.campaign campaign\nJOIN item.referencedTestCase referencedTestCase\nWHERE campaign.id = :campaignId";
        return this.em.createQuery(query).setParameter("campaignId", (Object)campaignId).getResultList();
    }

    public Collection<Long> findTestCasesAlreadyPlannedInIteration(long iterationId) {
        String query = "SELECT DISTINCT referencedTestCase.id\nFROM TestPlanItem item\nJOIN item.testPlan plan\nJOIN plan.parentIteration iteration\nJOIN item.referencedTestCase referencedTestCase\nWHERE iteration.id = :iterationId";
        return this.em.createQuery(query).setParameter("iterationId", (Object)iterationId).getResultList();
    }

    public List<String> findIterationNamesForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_NAMES).setParameter("id", (Object)campaignId).getResultList();
    }

    public List<CustomField> findIterationCutomfieldsForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_CUFS).setParameter("cpgId", (Object)campaignId).setParameter("boundEntity", (Object)BindableEntity.ITERATION).getResultList();
    }

    public Set<String> filterFeatures(List<String> keys2) {
        if (keys2.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_SYNC_KEY).setParameter("keys", keys2).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterBugfixes(List<String> keys2) {
        if (keys2.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_BUGFIXES_KEY).setParameter("keys", keys2).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterCoveredFeatures(List<String> keys2) {
        if (keys2.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_COVERED_REQS).setParameter("keys", keys2).getResultList();
        return new HashSet<String>(res);
    }

    public List<ExecplanTestCase> findTestCasesFixedBy(Collection<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return Collections.emptyList();
        }
        String query = "SELECT referencedTestCase.id,\n       referencedTestCase.name,\n       referencedTestCase.reference,\n       issue.remoteIssueId\nFROM Execution execution\nJOIN execution.issues issue\nJOIN execution.referencedTestCase referencedTestCase\nWHERE issue.remoteIssueId IN (:issueKeys)\n  AND referencedTestCase.project.id IN :projectIds";
        List results = this.em.createQuery(query).setParameter("issueKeys", issueKeys).setParameter("projectIds", (Object)this.currentUserHelper.findReadableProjectIds()).getResultList();
        LinkedHashMap<Long, ExecplanTestCase> testCaseMap = new LinkedHashMap<Long, ExecplanTestCase>();
        for (Tuple tuple : results) {
            Long testCaseId = (Long)tuple.get(0, Long.class);
            ExecplanTestCase testCase = testCaseMap.computeIfAbsent(testCaseId, id -> new ExecplanTestCase((Long)id, (String)tuple.get(1, String.class), (String)tuple.get(2, String.class)));
            testCase.getIssues().add(new ExecplanGitLabIssue((String)tuple.get(3, String.class)));
        }
        return new ArrayList<ExecplanTestCase>(testCaseMap.values());
    }

    public List<ExecplanTestCase> findTestCasesCoveringFeatures(Collection<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return Collections.emptyList();
        }
        String query = "SELECT testCase.id,\n       testCase.name,\n       testCase.reference,\n       reqVersion.id,\n       reqVersion.reference,\n       syncExtender.remoteReqId\nFROM TestCase testCase\nJOIN testCase.requirementVersionCoverages coverage\nJOIN coverage.verifiedRequirementVersion reqVersion\nJOIN reqVersion.requirement requirement\nJOIN requirement.syncExtender syncExtender\nWHERE syncExtender.remoteReqId IN (:issueKeys)\n  AND testCase.project.id IN :projectIds";
        List results = this.em.createQuery(query, Tuple.class).setParameter("issueKeys", issueKeys).setParameter("projectIds", (Object)this.currentUserHelper.findReadableProjectIds()).getResultList();
        LinkedHashMap<Long, ExecplanTestCase> testCaseMap = new LinkedHashMap<Long, ExecplanTestCase>();
        for (Tuple tuple : results) {
            Long testCaseId = (Long)tuple.get(0, Long.class);
            ExecplanTestCase testCase = testCaseMap.computeIfAbsent(testCaseId, id -> new ExecplanTestCase((Long)id, (String)tuple.get(1, String.class), (String)tuple.get(2, String.class)));
            testCase.getRequirements().add(new ExecplanRequirement((Long)tuple.get(3, Long.class), (String)tuple.get(4, String.class), (String)tuple.get(5, String.class)));
        }
        return new ArrayList<ExecplanTestCase>(testCaseMap.values());
    }
}

