/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupBoardsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectBoardsQuery;

public class GitLabBoardConverter {
    public static List<GitLabNamedReferenceDto> convertProjectBoards(@Nullable GetProjectBoardsQuery.Data data) {
        List nodes = Optional.ofNullable(data).map(GetProjectBoardsQuery.Data::project).map(GetProjectBoardsQuery.Project::boards).map(GetProjectBoardsQuery.Boards::nodes).orElse(Collections.emptyList());
        return nodes.stream().map(GitLabBoardConverter::convertOne).collect(Collectors.toList());
    }

    private static GitLabNamedReferenceDto convertOne(GetProjectBoardsQuery.Node node) {
        return new GitLabNamedReferenceDto(node.id(), node.name());
    }

    public static List<GitLabNamedReferenceDto> convertGroupBoards(@Nullable GetGroupBoardsQuery.Data data) {
        List nodes = Optional.ofNullable(data).map(GetGroupBoardsQuery.Data::group).map(GetGroupBoardsQuery.Group::boards).map(GetGroupBoardsQuery.Boards::nodes).orElse(Collections.emptyList());
        return nodes.stream().map(GitLabBoardConverter::convertOne).collect(Collectors.toList());
    }

    private static GitLabNamedReferenceDto convertOne(GetGroupBoardsQuery.Node node) {
        return new GitLabNamedReferenceDto(node.id(), node.name());
    }

    private GitLabBoardConverter() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }
}

