/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.FieldMapping;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.UserConfiguration;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.ValueMappings;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.scanner.ScannerException;

@Service(value="squash.tm.plugin.xsquash4gitlab.userConfigurationService")
@Transactional
public class UserConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserConfigurationService.class);
    public static final String FIELD_MAPPING = "attributeMappings";
    public static final String VALUES_MAPPING = "valuesMapping";
    public static final String TEST_REPORTING_ENABLED = "testReportingEnabled";
    private final ObjectMapper objectMapper;
    private final GenericProjectManagerService projectManager;

    public UserConfigurationService(ObjectMapper objectMapper, GenericProjectManagerService projectManager) {
        this.objectMapper = objectMapper;
        this.projectManager = projectManager;
    }

    public UserConfiguration getUserConfiguration(Long projectId) {
        Map conf = this.projectManager.getPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.xsquash4gitlab");
        UserConfiguration userConfiguration = new UserConfiguration();
        this.restoreFieldMappings(userConfiguration, conf);
        this.restoreValueMappings(userConfiguration, conf);
        if (conf.containsKey(TEST_REPORTING_ENABLED)) {
            userConfiguration.setTestReportingEnabled(Boolean.parseBoolean((String)conf.get(TEST_REPORTING_ENABLED)));
        }
        return userConfiguration;
    }

    private void restoreFieldMappings(UserConfiguration userConfiguration, Map<String, String> rawConfiguration) {
        block2: {
            String serializedMappings = rawConfiguration.getOrDefault(FIELD_MAPPING, "[]");
            try {
                List mappings = (List)this.objectMapper.readValue(serializedMappings, (TypeReference)new TypeReference<List<FieldMapping>>(){});
                FieldMapping.getLockedBuiltinMapping().stream().filter(builtInMapping -> mappings.stream().noneMatch(mapping -> builtInMapping.getId().equals(mapping.getId()))).forEach(mappings::add);
                userConfiguration.setFieldMappings(mappings);
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("could not parse field mapping " + serializedMappings + " for project ", (Throwable)e);
            }
        }
    }

    private void restoreValueMappings(UserConfiguration userConfiguration, Map<String, String> rawConfiguration) {
        block2: {
            String yamlValueString = rawConfiguration.getOrDefault(VALUES_MAPPING, "");
            try {
                Yaml yaml = new Yaml();
                yaml.load(yamlValueString);
                userConfiguration.setYamlFieldValueMapping(yamlValueString);
            }
            catch (ScannerException ex) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("could not parse field value mapping " + yamlValueString + " for project ", (Throwable)ex);
            }
        }
    }

    public ValueMappings getValueMappings(String yamlFieldValueMapping) {
        Yaml yaml = new Yaml();
        HashMap<String, Map<String, String>> parsed = new HashMap();
        try {
            parsed = (Map)yaml.load(yamlFieldValueMapping);
        }
        catch (ClassCastException ex) {
            LOGGER.error("YAML configuration error.", (Throwable)ex);
        }
        if (parsed == null) {
            parsed = new HashMap();
        }
        return new ValueMappings(parsed);
    }
}

